/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.spi;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.spi.SpiClassLoader;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.CollectionUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;

public final class ServiceLoaderUtil {
    private static final String JAVA_SPI_PATH_PREFIX = "META-INF/services/";
    private static final String CLASSLOADER_DEFAULT = "default";
    private static final String CLASSLOADER_CONTEXT = "context";
    private static ClassLoader appContextClassLoader;
    private static ClassLoader spiClassLoader;

    public static <S> ServiceLoader<S> getServiceLoader(Class<S> clazz) {
        if (ServiceLoaderUtil.shouldUseContextClassloader()) {
            return ServiceLoader.load(clazz);
        }
        return ServiceLoader.load(clazz, clazz.getClassLoader());
    }

    public static <S> ClassLoader getTargetClassLoader(Class<S> clazz) {
        if (ServiceLoaderUtil.shouldUseContextClassloader()) {
            return Thread.currentThread().getContextClassLoader();
        }
        return clazz.getClassLoader();
    }

    public static boolean shouldUseContextClassloader() {
        String classloaderConf = SentinelConfig.getConfig("io.opentelemetry.javaagent.mse.shaded.csp.sentinel.spi.classloader");
        return CLASSLOADER_CONTEXT.equalsIgnoreCase(classloaderConf);
    }

    public static void setAppContextClassLoader(ClassLoader appContextClassLoader) {
        ServiceLoaderUtil.appContextClassLoader = appContextClassLoader;
    }

    public static ClassLoader getAppContextClassLoader() {
        return appContextClassLoader;
    }

    public static Map<String, Class<?>> findImplClasses(Class<?> clazz, ClassLoader classLoader) {
        AssertUtil.assertNotNull(clazz, "class type can not be null");
        return ServiceLoaderUtil.findImplClasses(clazz, classLoader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Class<?>> findImplClasses(Class<?> type, ClassLoader loader, Set<String> excludePackages) {
        AssertUtil.assertNotNull(type, "class type can not be null");
        if (loader == null) {
            loader = spiClassLoader;
        }
        LinkedHashMap repo = new LinkedHashMap();
        try {
            Enumeration<URL> urlEnums = ServiceLoaderUtil.findResource(loader, JAVA_SPI_PATH_PREFIX + type.getName());
            while (urlEnums.hasMoreElements()) {
                BufferedReader br = null;
                URL currentUrl = urlEnums.nextElement();
                try {
                    String classNameStr;
                    br = new BufferedReader(new InputStreamReader(currentUrl.openStream()));
                    while ((classNameStr = br.readLine()) != null) {
                        if (!StringUtil.isNotBlank(classNameStr) || classNameStr.contains("#")) continue;
                        String className = classNameStr.trim();
                        boolean exclude = false;
                        if (!CollectionUtil.isEmpty(excludePackages)) {
                            for (String excludePack : excludePackages) {
                                if (!className.startsWith(excludePack)) continue;
                                exclude = true;
                                break;
                            }
                        }
                        if (exclude) {
                            RecordLog.debug("[ServiceLoaderUtil] SPI implementation <{}> for SPI interface {} is exclude by package exclusion", className, type.getName());
                            continue;
                        }
                        try {
                            Class<?> impl = loader.loadClass(className);
                            if (type.isAssignableFrom(impl)) {
                                repo.put(className, impl);
                                continue;
                            }
                            RecordLog.warn("[ServiceLoaderUtil] SPI impl class <{}> does not implement SPI interface {}", className, type.getName());
                        }
                        catch (Throwable ex) {
                            RecordLog.error("[ServiceLoaderUtil] Error occurred when try to load SPI impl class <{}> for SPI interface {}", className, type.getName(), ex);
                        }
                    }
                }
                finally {
                    if (br == null) continue;
                    br.close();
                }
            }
        }
        catch (IOException ex) {
            RecordLog.warn("Error occurred when loading SPI definition for class {}, classLoader={}", type.getName(), loader, ex);
        }
        return repo;
    }

    private static Enumeration<URL> findResource(ClassLoader classLoader, String resourceName) throws IOException {
        Enumeration<Object> result = null;
        if (resourceName != null && classLoader != null) {
            result = classLoader.getResources(resourceName);
        }
        return result != null ? result : new EmptyEnumeration();
    }

    private ServiceLoaderUtil() {
    }

    static {
        spiClassLoader = new SpiClassLoader();
    }

    private static class EmptyEnumeration<E>
    implements Enumeration<E> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public E nextElement() {
            throw new NoSuchElementException();
        }
    }
}

