/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.metric;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class ContainerSystemMetricReader {
    public static final String CGROUP_CPUACCT_USAGE_DIR = "/sys/fs/cgroup/cpu/cpuacct.usage";
    public static final String CGROUP_CPU_SHARE_DIR = "/sys/fs/cgroup/cpu/cpu.shares";
    public static final String CGROUP_CPU_QUOTA_DIR = "/sys/fs/cgroup/cpu/cpu.cfs_quota_us";
    public static final String CGROUP_CPU_PERIOD_DIR = "/sys/fs/cgroup/cpu/cpu.cfs_period_us";
    public static final int CPU_SHARES_K8S_NOT_SET = 2;
    private long cpuShares = -1L;
    private long cpuQuota = -1L;
    private long cpuPeriod = -1L;
    private double cpuCores = -1.0;
    private double tickPerMillis = -1.0;
    private volatile double curCpuUsage = -1.0;
    private long prevCpuTotal = -1L;
    private final int periodMs;
    private Thread collectorTask = null;

    public ContainerSystemMetricReader(int periodMs) {
        this.periodMs = periodMs;
    }

    public void init() {
        this.cpuPeriod = this.readLongFromFile(CGROUP_CPU_PERIOD_DIR);
        this.cpuQuota = this.readLongFromFile(CGROUP_CPU_QUOTA_DIR);
        this.cpuShares = this.readLongFromFile(CGROUP_CPU_SHARE_DIR);
        if (this.cpuQuota > 0L && this.cpuPeriod > 0L) {
            this.cpuCores = (double)this.cpuQuota * 1.0 / (double)this.cpuPeriod;
        } else if (this.cpuShares > 0L) {
            this.cpuCores = this.cpuShares == 2L ? -1.0 : (double)this.cpuShares * 1.0 / 1024.0;
        }
        if (this.cpuCores > 0.0) {
            this.tickPerMillis = this.cpuCores * 1000.0 * 1000.0;
            if (this.collectorTask != null) {
                return;
            }
            this.collectorTask = new Thread(new Runnable(){

                @Override
                public void run() {
                    ContainerSystemMetricReader.this.loopCollect();
                }
            });
            this.collectorTask.setDaemon(true);
            this.collectorTask.setName("sentinel-container-system-metric-collector");
            this.collectorTask.start();
        } else {
            RecordLog.warn("Container system CPU metric is not available, cpuPeriod={}, cpuQuota={}, cpuShares={}", this.cpuPeriod, this.cpuQuota, this.cpuShares);
        }
    }

    public boolean isCpuMetricAvailable() {
        return this.cpuCores > 0.0;
    }

    public double getCurrentCpuUsage() {
        return this.curCpuUsage;
    }

    private void loopCollect() {
        while (true) {
            try {
                this.retrieveAndUpdateSystemStat();
            }
            catch (Throwable e) {
                RecordLog.warn("[ContainerSystemMetricCollectorTask] Failed to get and update container system metrics", e);
            }
            ContainerSystemMetricReader.sleepMs(this.periodMs);
        }
    }

    private void retrieveAndUpdateSystemStat() {
        long curCgroupCpuAcctUsage = this.getCgroupCpuAcctUsage();
        if (curCgroupCpuAcctUsage < 0L) {
            return;
        }
        if (this.prevCpuTotal > 0L) {
            double tick = this.tickPerMillis * (double)this.periodMs;
            double percentage = Math.max(0.0, (double)(curCgroupCpuAcctUsage - this.prevCpuTotal) / tick);
            this.curCpuUsage = Math.min(percentage, 1.0);
        }
        this.prevCpuTotal = curCgroupCpuAcctUsage;
    }

    private long getCgroupCpuAcctUsage() {
        return this.readLongFromFile(CGROUP_CPUACCT_USAGE_DIR);
    }

    private long readLongFromFile(String path) {
        try {
            String v = ContainerSystemMetricReader.readSingleLineFromFile(path);
            if (StringUtil.isBlank(v)) {
                return -1L;
            }
            return Long.parseLong(v);
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readSingleLineFromFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String string = reader.readLine();
            return string;
        }
        catch (Exception ex) {
            RecordLog.warn("[ContainerSystemMetricReader] Failed to read cgroup file: " + filePath, ex);
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    RecordLog.warn("[ContainerSystemMetricReader] Failed to close reader " + filePath, e);
                }
            }
        }
    }

    private static void sleepMs(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ignored) {
            RecordLog.warn("[ContainerSystemMetricReader] Failed to sleepMs ", ignored);
        }
    }
}

