/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.strategy;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.adaptive.AdaptiveFlowLogger;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.adaptive.pid.PIDController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.event.SimpleEvent;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.event.SimpleEventLevelEnum;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.action.StrategyAction;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.strategy.AdaptiveStatusListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.strategy.AdaptiveStrategy;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.metric.StrategyMetricObserver;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.TimeUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.VersionUtil;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class PIDAdaptiveStrategy
implements AdaptiveStrategy<Double> {
    private static final String type = "pid";
    private static final long DEFAULT_SAMPLE_LOG_INTERVAL_MS = 400L;
    private static final long DEFAULT_CONTINUE_EVENT_INTERVAL_MS = 120000L;
    private static final double DEFAULT_P = 0.5;
    private static final double DEFAULT_I = 0.2;
    private static final double DEFAULT_D = 0.3;
    private static final double DEFAULT_SP = 0.6;
    private PIDController pidController = new PIDController(0.5, 0.2, 0.3, 0.6);
    private volatile long lastSampleTimestamp = 0L;
    private volatile long lastReportContinueEventTimestamp = 0L;
    private volatile long lastStartTime = 0L;
    private Double targetMetric;
    private Double curMetric;
    private final double PROBABILITY_MAX = 1.0;
    private final double DIFF = 1.0E-6;
    private volatile double passProbability = 1.0;
    private volatile AdaptiveStatusListener listener;
    private static ThreadLocal<Random> randomThreadLocalForJdk6 = new ThreadLocal<Random>(){

        @Override
        public Random initialValue() {
            return new Random(TimeUtil.currentTimeMillis());
        }
    };

    @Override
    public boolean canPass(int count) {
        if (VersionUtil.isJdk7OrHigher()) {
            return ThreadLocalRandom.current().nextDouble() < this.passProbability;
        }
        return randomThreadLocalForJdk6.get().nextDouble() < this.passProbability;
    }

    @Override
    public void updateCurMetric(Double curMetric) {
        if (this.pidController == null) {
            return;
        }
        if (this.targetMetric == null || curMetric == null) {
            return;
        }
        this.curMetric = curMetric;
        if (this.targetMetric > 0.0) {
            double output = this.pidController.calcOutput(curMetric, this.targetMetric);
            double p = this.convertActionToProbability(curMetric, output);
            long curTime = TimeUtil.currentTimeMillis();
            if (p < 1.0 && curTime - this.lastSampleTimestamp >= 400L) {
                AdaptiveFlowLogger.info(String.format("[SAMPLE] curMetric=%.3f, o=%.3f, p=%.2f", curMetric, output, p), new Object[0]);
                this.lastSampleTimestamp = curTime;
            }
            this.generateEvent(this.passProbability, p);
            this.passProbability = p;
        }
    }

    @Override
    public void updateTargetMetric(Double metric) {
        this.targetMetric = metric;
    }

    private double convertActionToProbability(double curMetric, double output) {
        if (output >= 0.0) {
            return 1.0;
        }
        double e = 1.0E-4;
        if (curMetric >= -e && curMetric <= e) {
            return 1.0;
        }
        double negativeFeedback = Math.max(-curMetric, Math.min(output, 0.0));
        return (curMetric + negativeFeedback) / curMetric;
    }

    public void generateEvent(double curVal, double newVal) {
        if (this.listener == null) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        if (1.0 - curVal < 1.0E-6 && newVal < 1.0) {
            this.lastStartTime = timestamp;
            SimpleEvent event = this.buildEvent(timestamp, "sentinel_adaptive_event_start", curVal, newVal, SimpleEventLevelEnum.WARN);
            this.listener.onStart(event);
        } else if (curVal < 1.0 && 1.0 - newVal < 1.0E-6) {
            SimpleEvent event = this.buildEvent(timestamp, "sentinel_adaptive_event_end", curVal, newVal, SimpleEventLevelEnum.WARN);
            this.listener.onEnd(event);
        } else if (curVal < 1.0 && newVal < 1.0 && timestamp - this.lastReportContinueEventTimestamp >= 120000L) {
            this.lastReportContinueEventTimestamp = timestamp;
            SimpleEvent event = this.buildEvent(timestamp, "sentinel_adaptive_event_continue", curVal, newVal, SimpleEventLevelEnum.INFO);
            this.listener.onContinue(event);
        }
    }

    public SimpleEvent buildEvent(long timestamp, String name, double curVal, double newVal, SimpleEventLevelEnum level) {
        return new SimpleEvent().setTimestamp(timestamp).setType("sentinel_adaptive_event").setName(name).addAttribute("startTime", String.valueOf(this.lastStartTime)).addAttribute("curVal", String.format("%.2f", curVal)).addAttribute("newVal", String.format("%.2f", newVal)).addAttribute("target", String.format("%.2f", this.targetMetric)).addAttribute("cur", String.format("%.2f", this.curMetric)).setEventEnum(level);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public void enable() {
        this.pidController = new PIDController(0.5, 0.2, 0.3, 0.6);
    }

    @Override
    public void disable() {
        this.pidController = null;
        this.passProbability = 1.0;
    }

    @Override
    public void bind(StrategyMetricObserver observer, StrategyAction strategyAction) {
        if (strategyAction instanceof AdaptiveStatusListener) {
            this.listener = (AdaptiveStatusListener)((Object)strategyAction);
        }
    }
}

