/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.EntryType;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.AdaptiveController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.AdaptiveControllerConstant;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.action.BlockAction;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.action.MockAction;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.action.StrategyAction;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.strategy.AdaptiveStrategy;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.metric.StrategyMetricObserver;
import java.util.Map;

public class DefaultAdaptiveController
implements AdaptiveController {
    String type;
    String limitType;
    AdaptiveStrategy<?> adaptiveStrategy;
    StrategyAction strategyAction;
    StrategyMetricObserver metricObserver;
    boolean enable = true;

    public DefaultAdaptiveController(AdaptiveStrategy<?> adaptiveStrategy, StrategyMetricObserver metricObserver, StrategyAction strategyAction, String limitType) {
        this.adaptiveStrategy = adaptiveStrategy;
        this.strategyAction = strategyAction;
        this.type = AdaptiveControllerConstant.genControllerType(adaptiveStrategy.getType(), metricObserver.getType());
        this.metricObserver = metricObserver;
        this.limitType = limitType;
        metricObserver.bind(adaptiveStrategy);
        adaptiveStrategy.bind(metricObserver, strategyAction);
    }

    @Override
    public void tryPass(ResourceWrapper rw, int count) throws SystemBlockException {
        if (!this.enable || rw == null || rw.getEntryType() != EntryType.IN) {
            return;
        }
        boolean canPass = true;
        if (this.adaptiveStrategy != null) {
            canPass = this.adaptiveStrategy.canPass(count);
        }
        if (this.strategyAction != null) {
            this.strategyAction.doAction(canPass, rw);
        }
    }

    @Override
    public void updateDefinition(Map<String, String> definition) {
        this.metricObserver.updateDefinition(definition);
    }

    @Override
    public void updateStrategyAction(String action) {
        if (!this.strategyAction.getType().equals(action)) {
            StrategyAction newStrategyAction;
            if ("block".equals(action)) {
                newStrategyAction = new BlockAction(this.limitType);
            } else if ("mock".equals(action)) {
                newStrategyAction = new MockAction(this.limitType);
            } else {
                RecordLog.warn("[DefaultAdaptiveController] illegal action use MockAction", new Object[0]);
                newStrategyAction = new MockAction(this.limitType);
            }
            this.strategyAction = newStrategyAction;
            this.adaptiveStrategy.bind(this.metricObserver, this.strategyAction);
        }
    }

    @Override
    public void updateControllerConfig(Map<String, String> controllerConfig) {
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void enable() {
        this.enable = true;
        this.adaptiveStrategy.enable();
    }

    @Override
    public void disable() {
        this.enable = false;
        this.adaptiveStrategy.disable();
    }

    @Override
    public boolean isEnabled() {
        return this.enable;
    }
}

