/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.context.Context;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.DefaultNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.AbstractLinkedProcessorSlot;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.AdaptiveController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.AdaptiveControllerRuleManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.whitelist.WhiteListConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.whitelist.WhiteListConfigManager;
import java.util.Map;

public class AdaptiveSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    private static final String PID_CPU = "pid-cpu";
    private static final String BASIC_QPS = "basic-qps";
    private static final String BASIC_CONCURRENCY = "basic-concurrency";

    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        this.checkAdaptiveController(resourceWrapper, count);
        this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
    }

    @Override
    public void exit(Context context, ResourceWrapper resourceWrapper, int count, Object ... args) {
        this.fireExit(context, resourceWrapper, count, args);
    }

    private void checkAdaptiveController(ResourceWrapper rw, int count) throws BlockException {
        Map<String, AdaptiveController> controllerMap = AdaptiveControllerRuleManager.getAdaptiveControllerMap();
        if (controllerMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, AdaptiveController> e : controllerMap.entrySet()) {
            if (!this.shouldCheck(rw, e.getValue())) continue;
            e.getValue().tryPass(rw, count);
        }
    }

    private boolean shouldCheck(ResourceWrapper r, AdaptiveController adaptiveController) {
        WhiteListConfig whiteListConfig;
        String resourceName = r.getName();
        switch (adaptiveController.getType()) {
            case "pid-cpu": {
                whiteListConfig = WhiteListConfigManager.getWhiteList("adaptive_cpu");
                break;
            }
            case "basic-qps": {
                whiteListConfig = WhiteListConfigManager.getWhiteList("adaptive_inbound_qps");
                break;
            }
            case "basic-concurrency": {
                whiteListConfig = WhiteListConfigManager.getWhiteList("adaptive_inbound_concurrency");
                break;
            }
            default: {
                return true;
            }
        }
        if (whiteListConfig == null) {
            return true;
        }
        return !whiteListConfig.getWhiteList().contains(resourceName);
    }
}

