/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SimplePropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.AdaptiveController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.AdaptiveControllerConstant;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.AdaptiveControllerRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.DefaultAdaptiveController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.action.BlockAction;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.action.MockAction;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.action.StrategyAction;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.strategy.AdaptiveStrategy;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.strategy.BasicStrategy;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.adaptive.strategy.PIDAdaptiveStrategy;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.metric.CPUMetricObserver;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.metric.InboundConcurrencyMetricObserver;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.metric.InboundQPSMetricObserver;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.metric.StrategyMetricObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AdaptiveControllerRuleManager {
    private static volatile Map<String, AdaptiveController> adaptiveControllerMap = new HashMap<String, AdaptiveController>();
    private static final AdaptivePropertyListener LISTENER = new AdaptivePropertyListener();
    private static SentinelProperty<List<AdaptiveControllerRule>> currentProperty = new DynamicSentinelProperty<List<AdaptiveControllerRule>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<AdaptiveControllerRule>> property) {
        AdaptivePropertyListener adaptivePropertyListener = LISTENER;
        synchronized (adaptivePropertyListener) {
            RecordLog.info("[AdaptiveControllerRuleManager] Registering new property to adaptive controller rule manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    public static void loadRules(List<AdaptiveControllerRule> rules) {
        try {
            currentProperty.updateValue(rules);
        }
        catch (Throwable e) {
            RecordLog.warn("[AdaptiveControllerRuleManager] Unexpected error when loading adaptive controller rules", e);
        }
    }

    public static List<AdaptiveController> getControllers() {
        ArrayList<AdaptiveController> result = new ArrayList<AdaptiveController>();
        for (Map.Entry<String, AdaptiveController> e : adaptiveControllerMap.entrySet()) {
            if (e.getValue() == null) continue;
            result.add(e.getValue());
        }
        return result;
    }

    public static Map<String, AdaptiveController> getAdaptiveControllerMap() {
        return adaptiveControllerMap;
    }

    public static boolean isValidRule(AdaptiveControllerRule rule) {
        if (rule.getDefinition() == null || rule.getDefinition().size() == 0) {
            return false;
        }
        if (rule.getAction() == null || !AdaptiveControllerConstant.STRATEGY_ACTION_TYPE.contains(rule.getAction())) {
            return false;
        }
        if (rule.getStrategy() == null || !AdaptiveControllerConstant.STRATEGY_TYPE.contains(rule.getStrategy())) {
            return false;
        }
        if (rule.getMetricType() == null || !AdaptiveControllerConstant.METRIC_TYPE.contains(rule.getMetricType())) {
            return false;
        }
        if (rule.getScene() == null) {
            return false;
        }
        if ("cpu".equals(rule.getMetricType())) {
            float cpuUsage;
            if (!rule.getDefinition().containsKey("cpu_usage")) {
                return false;
            }
            try {
                cpuUsage = Float.parseFloat(rule.getDefinition().get("cpu_usage"));
            }
            catch (Exception e) {
                RecordLog.warn("[AdaptiveControllerRuleManager] Float.parseFloat error", e);
                return false;
            }
            if (cpuUsage < 0.0f || cpuUsage > 1.0f) {
                return false;
            }
        }
        if ("qps".equals(rule.getMetricType())) {
            double qps;
            if (!rule.getDefinition().containsKey("inbound_qps")) {
                return false;
            }
            try {
                qps = Double.parseDouble(rule.getDefinition().get("inbound_qps"));
            }
            catch (Exception e) {
                RecordLog.warn("[AdaptiveControllerRuleManager] Integer.parseInt error", e);
                return false;
            }
            return qps >= 0.0;
        }
        if ("concurrency".equals(rule.getMetricType())) {
            int concurrency;
            if (!rule.getDefinition().containsKey("inbound_concurrency")) {
                return false;
            }
            try {
                concurrency = Integer.parseInt(rule.getDefinition().get("inbound_concurrency"));
            }
            catch (Exception e) {
                RecordLog.warn("[AdaptiveControllerRuleManager] Integer.parseInt error", e);
                return false;
            }
            return concurrency >= 0;
        }
        return true;
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    static class AdaptivePropertyListener
    extends SimplePropertyListener<List<AdaptiveControllerRule>> {
        AdaptivePropertyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void configUpdate(List<AdaptiveControllerRule> rules) {
            Map<String, AdaptiveController> controllerMap = this.generateControllerMap(rules);
            AdaptivePropertyListener adaptivePropertyListener = this;
            synchronized (adaptivePropertyListener) {
                adaptiveControllerMap = controllerMap;
            }
            RecordLog.info("[AdaptiveControllerRuleManager] Adaptive controller rule loaded: " + controllerMap.toString(), new Object[0]);
        }

        public Map<String, AdaptiveController> generateControllerMap(List<AdaptiveControllerRule> rules) {
            String controllerType;
            HashMap<String, AdaptiveController> map = new HashMap<String, AdaptiveController>();
            if (rules != null) {
                block18: for (AdaptiveControllerRule adaptiveControllerRule : rules) {
                    AdaptiveController adaptiveController;
                    if (!AdaptiveControllerRuleManager.isValidRule(adaptiveControllerRule)) {
                        RecordLog.warn("[AdaptiveControllerRuleManager] Ignoring invalid rule when loading new rules: " + adaptiveControllerRule, new Object[0]);
                        continue;
                    }
                    controllerType = AdaptiveControllerConstant.genControllerType(adaptiveControllerRule.getStrategy(), adaptiveControllerRule.getMetricType());
                    if (adaptiveControllerMap.containsKey(controllerType)) {
                        adaptiveController = (AdaptiveController)adaptiveControllerMap.get(controllerType);
                    } else {
                        StrategyAction action;
                        StrategyMetricObserver metricObserver;
                        AdaptiveStrategy<Double> strategy;
                        switch (adaptiveControllerRule.getStrategy()) {
                            case "pid": {
                                strategy = new PIDAdaptiveStrategy();
                                break;
                            }
                            case "basic": {
                                strategy = new BasicStrategy();
                                break;
                            }
                            default: {
                                RecordLog.warn("[AdaptiveControllerRuleManager] Ignoring invalid rule when loading new rules: " + adaptiveControllerRule, new Object[0]);
                                continue block18;
                            }
                        }
                        switch (adaptiveControllerRule.getMetricType()) {
                            case "cpu": {
                                metricObserver = new CPUMetricObserver();
                                break;
                            }
                            case "qps": {
                                metricObserver = new InboundQPSMetricObserver();
                                break;
                            }
                            case "concurrency": {
                                metricObserver = new InboundConcurrencyMetricObserver();
                                break;
                            }
                            default: {
                                RecordLog.warn("[AdaptiveControllerRuleManager] Ignoring invalid rule when loading new rules: " + adaptiveControllerRule, new Object[0]);
                                continue block18;
                            }
                        }
                        if ("block".equals(adaptiveControllerRule.getAction())) {
                            action = new BlockAction(adaptiveControllerRule.getScene());
                        } else if ("mock".equals(adaptiveControllerRule.getAction())) {
                            action = new MockAction(adaptiveControllerRule.getScene());
                        } else {
                            RecordLog.warn("[AdaptiveControllerRuleManager] Ignoring invalid rule when loading new rules: " + adaptiveControllerRule, new Object[0]);
                            continue;
                        }
                        adaptiveController = new DefaultAdaptiveController(strategy, metricObserver, action, adaptiveControllerRule.getScene());
                    }
                    adaptiveController.updateDefinition(adaptiveControllerRule.getDefinition());
                    adaptiveController.updateStrategyAction(adaptiveControllerRule.getAction());
                    adaptiveController.enable();
                    map.put(controllerType, adaptiveController);
                }
            }
            for (Map.Entry entry : adaptiveControllerMap.entrySet()) {
                controllerType = (String)entry.getKey();
                AdaptiveController controller = (AdaptiveController)entry.getValue();
                if (map.containsKey(controllerType)) continue;
                controller.disable();
                map.put(controllerType, controller);
            }
            return map;
        }
    }
}

