/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.AbstractRule;

public class SystemRule
extends AbstractRule {
    private double highestSystemLoad = -1.0;
    private double highestCpuUsage = -1.0;
    private double qps = -1.0;
    private long avgRt = -1L;
    private long maxThread = -1L;

    public double getQps() {
        return this.qps;
    }

    public SystemRule setQps(double qps) {
        this.qps = qps;
        return this;
    }

    public long getMaxThread() {
        return this.maxThread;
    }

    public SystemRule setMaxThread(long maxThread) {
        this.maxThread = maxThread;
        return this;
    }

    public long getAvgRt() {
        return this.avgRt;
    }

    public SystemRule setAvgRt(long avgRt) {
        this.avgRt = avgRt;
        return this;
    }

    public double getHighestSystemLoad() {
        return this.highestSystemLoad;
    }

    public SystemRule setHighestSystemLoad(double highestSystemLoad) {
        this.highestSystemLoad = highestSystemLoad;
        return this;
    }

    public double getHighestCpuUsage() {
        return this.highestCpuUsage;
    }

    public SystemRule setHighestCpuUsage(double highestCpuUsage) {
        this.highestCpuUsage = highestCpuUsage;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SystemRule that = (SystemRule)o;
        if (Double.compare(that.highestSystemLoad, this.highestSystemLoad) != 0) {
            return false;
        }
        if (Double.compare(that.highestCpuUsage, this.highestCpuUsage) != 0) {
            return false;
        }
        if (Double.compare(that.qps, this.qps) != 0) {
            return false;
        }
        if (this.avgRt != that.avgRt) {
            return false;
        }
        return this.maxThread == that.maxThread;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.highestSystemLoad);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.highestCpuUsage);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.qps);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.avgRt ^ this.avgRt >>> 32);
        result = 31 * result + (int)(this.maxThread ^ this.maxThread >>> 32);
        return result;
    }

    public String toString() {
        return "SystemRule{highestSystemLoad=" + this.highestSystemLoad + ", highestCpuUsage=" + this.highestCpuUsage + ", qps=" + this.qps + ", avgRt=" + this.avgRt + ", maxThread=" + this.maxThread + "}";
    }
}

