/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.statistic.metric.param;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ParamsMetric {
    private static volatile ParamsMetric paramsMetric;
    public static final String SEG = "->";
    private static final int MAX_HOT_SIZE = 20;
    private static final int MAX_HOT_KEY_SIZE = 10;
    private final Map<String, Set<String>> paramKeys = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Integer> paramSize = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> paramKeySize = new ConcurrentHashMap<String, Integer>();
    private final Map<String, Integer> blocked = new ConcurrentHashMap<String, Integer>();

    private ParamsMetric() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParamsMetric getInstance() {
        if (paramsMetric != null) return paramsMetric;
        Class<ParamsMetric> clazz = ParamsMetric.class;
        synchronized (ParamsMetric.class) {
            if (paramsMetric != null) return paramsMetric;
            paramsMetric = new ParamsMetric();
            // ** MonitorExit[var0] (shouldn't be in output)
            return paramsMetric;
        }
    }

    private boolean addParam(String ruleName, String hotParam) {
        try {
            Integer paramKeyLen;
            String[] infos;
            String key;
            Integer paramLen;
            String rule;
            if (!this.paramKeys.containsKey(ruleName) && this.paramKeys.size() > 20 && (rule = this.getCoolKey(null, this.paramSize)) != null) {
                this.paramKeys.remove(rule);
            }
            if ((paramLen = this.paramSize.get(ruleName)) == null) {
                paramLen = 0;
            }
            this.paramSize.put(ruleName, paramLen + 1);
            Set<String> keys = this.paramKeys.get(ruleName);
            if (keys == null) {
                keys = Collections.newSetFromMap(new ConcurrentHashMap());
            }
            if (!keys.contains(hotParam) && keys.size() > 10 && (key = this.getCoolKey(ruleName, this.paramKeySize)) != null && (infos = key.split(SEG)).length > 1) {
                keys.remove(infos[1]);
            }
            if ((paramKeyLen = this.paramKeySize.get(ruleName + SEG + hotParam)) == null) {
                paramKeyLen = 0;
            }
            this.paramKeySize.put(ruleName + SEG + hotParam, paramKeyLen + 1);
            keys.add(hotParam);
            this.paramKeys.put(ruleName, keys);
            return true;
        }
        catch (Throwable e) {
            RecordLog.error("[PARAM-METRIC] failed to record param block metric, ruleName={}", ruleName, e);
            return false;
        }
    }

    private String getCoolKey(String pre, Map<String, Integer> params) {
        Iterator<Map.Entry<String, Integer>> iterator = params.entrySet().iterator();
        int min = Integer.MAX_VALUE;
        String rule = null;
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> entry = iterator.next();
            if (pre != null && !entry.getKey().startsWith(pre) || entry.getValue() >= min) continue;
            min = entry.getValue();
            rule = entry.getKey();
        }
        return rule;
    }

    private void rmvParam() {
        this.paramKeys.clear();
        this.blocked.clear();
        this.paramSize.clear();
        this.paramKeySize.clear();
    }

    public void setBlockedQps(String resource, String index, int count, String hotParam) {
        String ruleName = resource + SEG + index + SEG + hotParam;
        String rule = resource + SEG + index;
        boolean added = this.addParam(rule, hotParam);
        if (!added) {
            return;
        }
        this.setParams(ruleName, count, this.blocked);
    }

    private void setParams(String ruleName, int count, Map<String, Integer> qps) {
        Integer num = qps.get(ruleName);
        if (num == null) {
            num = 0;
        }
        qps.put(ruleName, num + count);
    }

    public List<String> getHotParamStatistics() {
        ArrayList<String> params = new ArrayList<String>(this.paramKeys.size());
        for (Map.Entry<String, Set<String>> entry : this.paramKeys.entrySet()) {
            String rule = entry.getKey();
            StringBuilder builder = new StringBuilder();
            builder.append(rule);
            for (String hotParam : entry.getValue()) {
                String ruleName = rule + SEG + hotParam;
                builder.append("#").append(hotParam).append("!").append(this.blocked.get(ruleName));
            }
            params.add(builder.toString());
        }
        this.rmvParam();
        return params;
    }

    public Set<String> paramsKeys() {
        return this.paramKeys.keySet();
    }
}

