/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.statistic;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.context.Context;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.DefaultNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ProcessorSlotEntryCallback;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetric;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetricStorage;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.statistic.metric.param.ParamsMetricManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Map;

public class ParamFlowStatisticEntryCallback
implements ProcessorSlotEntryCallback<DefaultNode> {
    @Override
    public void onPass(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, Object ... args) {
        ParameterMetric parameterMetric = ParameterMetricStorage.getParamMetric(resourceWrapper);
        if (parameterMetric != null) {
            Map<String, Object> argMap = context.getCurEntry().getArgMap();
            parameterMetric.increaseConcurrency(argMap);
            parameterMetric.addThreadCount(args);
        }
    }

    @Override
    public void onBlocked(BlockException ex, Context context, ResourceWrapper resourceWrapper, DefaultNode param, int batchCount, Object ... args) {
        try {
            if (ex instanceof ParamFlowException) {
                ParamFlowRule paramFlowRule = ((ParamFlowException)ex).getRule();
                String key = paramFlowRule.getParamKey();
                Integer index = paramFlowRule.getParamIdx();
                if (StringUtil.isEmpty(key)) {
                    ParamsMetricManager.getInstance().setBlockedParams(resourceWrapper.getName(), String.valueOf(index), batchCount, String.valueOf(args[index]));
                } else {
                    ParamsMetricManager.getInstance().setBlockedParams(resourceWrapper.getName(), key, batchCount, ((ParamFlowException)ex).getLimitParam());
                }
            }
        }
        catch (Throwable e) {
            RecordLog.error("Failed to record parameter block metric for resource {}", resourceWrapper.getName(), e);
        }
    }
}

