/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.statuscode;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.EntryType;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricWriter;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.statuscode.StatusCodeMetric;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class StatusCodeMetricManager {
    private static volatile StatusCodeMetricManager statusCodeManager;
    private static final long ONE_MINUTE = 60000L;
    private static final String STATUS_FILE = "status_metrics.log";
    private final MetricWriter metricWriter = new MetricWriter(SentinelConfig.singleMetricFileSize(), SentinelConfig.totalMetricFileCount());
    private final Set<Long> times = new ConcurrentSkipListSet<Long>();
    private static final int KEEP_ALIVE_TIME = 120000;
    private static final int QUEUE_SIZE = 40960;
    private static final ExecutorService fetchService;
    private static final ScheduledExecutorService scheduler;
    TimerTask writeTask = new TimerTask(){

        @Override
        public void run() {
            try {
                Long innerTime;
                long time = TimeUtil.currentTimeMillis() - 60000L;
                HashSet<Long> innerTimes = new HashSet<Long>();
                Iterator iterator = StatusCodeMetricManager.this.times.iterator();
                while (iterator.hasNext() && (innerTime = (Long)iterator.next()) <= time) {
                    innerTimes.add(innerTime);
                    List<String> keys = StatusCodeMetric.getInstance().getKeys();
                    ArrayList<MetricNode> metricNodes = new ArrayList<MetricNode>();
                    for (String key : keys) {
                        Map<Long, AtomicInteger[]> metrics = StatusCodeMetric.getInstance().getMetrics(key);
                        AtomicInteger[] statistics = metrics.get(innerTime);
                        if (statistics == null) continue;
                        MetricNode node = new MetricNode();
                        node.setResource(key);
                        node.setPassQps(statistics[1].get());
                        node.setBlockQps(statistics[3].get());
                        node.setSuccessQps(statistics[0].get());
                        node.setExceptionQps(statistics[4].get());
                        node.setRt(statistics[2].get());
                        node.setTrafficType(EntryType.IN);
                        metricNodes.add(node);
                        metrics.remove(innerTime);
                        StatusCodeMetric.getInstance().setMetrics(key, metrics);
                    }
                    StatusCodeMetricManager.this.metricWriter.write(innerTime, metricNodes, StatusCodeMetricManager.STATUS_FILE);
                }
                StatusCodeMetricManager.this.times.removeAll(innerTimes);
            }
            catch (Exception e) {
                RecordLog.warn("Failed to write HTTP status metrics on disk", e);
            }
        }
    };

    private StatusCodeMetricManager() {
        scheduler.scheduleWithFixedDelay(this.writeTask, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StatusCodeMetricManager getInstance() {
        if (statusCodeManager != null) return statusCodeManager;
        Class<StatusCodeMetricManager> clazz = StatusCodeMetricManager.class;
        synchronized (StatusCodeMetricManager.class) {
            if (statusCodeManager != null) return statusCodeManager;
            statusCodeManager = new StatusCodeMetricManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return statusCodeManager;
        }
    }

    public boolean recordStatusCode(final String resource, final int statusCode) {
        try {
            long time = TimeUtil.currentTimeMillis();
            time -= time % 1000L;
            this.times.add(time);
            final long finalTime = time;
            fetchService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        StatusCodeMetric.getInstance().statisticStatusCode(resource, finalTime, statusCode);
                    }
                    catch (Throwable e) {
                        RecordLog.warn("[STATIC-STATUS-CODE] failed, {}, {}, {}", resource, finalTime, statusCode, e);
                    }
                }
            });
            return true;
        }
        catch (Exception ex) {
            RecordLog.error("Failed to recordStatusCode for resource {}", resource, ex);
            return false;
        }
    }

    public String getStatisticStatusCode(String resource, long time) {
        time -= time % 1000L;
        return StatusCodeMetric.getInstance().getStatisticStatusCode(resource, time);
    }

    static {
        fetchService = new ThreadPoolExecutor(1, 1, 120000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(40960), new NamedThreadFactory("sentinel-stat-status-code-record-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
        int coreNum = Runtime.getRuntime().availableProcessors();
        scheduler = Executors.newScheduledThreadPool(coreNum, new NamedThreadFactory("sentinel-stat-status-code-write-task", true));
    }
}

