/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.statistic.cache.CacheMap;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.statistic.cache.ConcurrentLinkedHashMapWrapper;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ParameterMetric {
    private static final int THREAD_COUNT_MAX_CAPACITY = 4000;
    private static final int BASE_PARAM_MAX_CAPACITY = 4000;
    private static final int TOTAL_MAX_CAPACITY = 200000;
    private final Object lock = new Object();
    private final Map<ParamFlowRule, CacheMap<Object, AtomicLong>> ruleTimeCounters = new HashMap<ParamFlowRule, CacheMap<Object, AtomicLong>>();
    private final Map<ParamFlowRule, CacheMap<Object, AtomicLong>> ruleTokenCounter = new HashMap<ParamFlowRule, CacheMap<Object, AtomicLong>>();
    private final Map<Object, CacheMap<Object, AtomicInteger>> concurrencyMap = new HashMap<Object, CacheMap<Object, AtomicInteger>>();

    public CacheMap<Object, AtomicLong> getRuleTokenCounter(ParamFlowRule rule) {
        return this.ruleTokenCounter.get(rule);
    }

    public CacheMap<Object, AtomicLong> getRuleTimeCounter(ParamFlowRule rule) {
        return this.ruleTimeCounters.get(rule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.concurrencyMap.clear();
            this.ruleTimeCounters.clear();
            this.ruleTokenCounter.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearForRule(ParamFlowRule rule) {
        Object object = this.lock;
        synchronized (object) {
            this.ruleTimeCounters.remove(rule);
            this.ruleTokenCounter.remove(rule);
            this.concurrencyMap.remove(rule.getParamIdx());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ParamFlowRule rule) {
        long size;
        Object object;
        if (!this.ruleTimeCounters.containsKey(rule)) {
            object = this.lock;
            synchronized (object) {
                if (this.ruleTimeCounters.get(rule) == null) {
                    size = Math.min(4000L * rule.getDurationInSec(), 200000L);
                    this.ruleTimeCounters.put(rule, new ConcurrentLinkedHashMapWrapper(size));
                }
            }
        }
        if (!this.ruleTokenCounter.containsKey(rule)) {
            object = this.lock;
            synchronized (object) {
                if (this.ruleTokenCounter.get(rule) == null) {
                    size = Math.min(4000L * rule.getDurationInSec(), 200000L);
                    this.ruleTokenCounter.put(rule, new ConcurrentLinkedHashMapWrapper(size));
                }
            }
        }
        if (rule.getParamKey() != null) {
            if (!this.concurrencyMap.containsKey(rule.getParamKey())) {
                object = this.lock;
                synchronized (object) {
                    if (this.concurrencyMap.get(rule.getParamKey()) == null) {
                        this.concurrencyMap.put(rule.getParamKey(), new ConcurrentLinkedHashMapWrapper(4000L));
                    }
                }
            }
        } else if (rule.getParamIdx() != null && !this.concurrencyMap.containsKey(rule.getParamIdx())) {
            object = this.lock;
            synchronized (object) {
                if (this.concurrencyMap.get(rule.getParamIdx()) == null) {
                    this.concurrencyMap.put(rule.getParamIdx(), new ConcurrentLinkedHashMapWrapper(4000L));
                }
            }
        }
    }

    private void decreaseConcurrencyForValue(Object param, CacheMap<Object, AtomicInteger> ccMap) {
        if (Collection.class.isAssignableFrom(param.getClass())) {
            for (Object value : (Collection)param) {
                int currentValue;
                AtomicInteger oldValue = ccMap.putIfAbsent(value, new AtomicInteger());
                if (oldValue == null || (currentValue = oldValue.decrementAndGet()) > 0) continue;
                ccMap.remove(value);
            }
        } else if (param.getClass().isArray()) {
            int length = Array.getLength(param);
            for (int i = 0; i < length; ++i) {
                int currentValue;
                Object value = Array.get(param, i);
                AtomicInteger oldValue = ccMap.putIfAbsent(value, new AtomicInteger());
                if (oldValue == null || (currentValue = oldValue.decrementAndGet()) > 0) continue;
                ccMap.remove(value);
            }
        } else {
            int currentValue;
            AtomicInteger oldValue = ccMap.putIfAbsent(param, new AtomicInteger());
            if (oldValue != null && (currentValue = oldValue.decrementAndGet()) <= 0) {
                ccMap.remove(param);
            }
        }
    }

    public void decreaseConcurrency(Map<String, Object> argMap) {
        if (argMap == null || argMap.isEmpty()) {
            return;
        }
        try {
            for (Map.Entry<String, Object> e : argMap.entrySet()) {
                Object arg;
                CacheMap<Object, AtomicInteger> ccMap = this.concurrencyMap.get(e.getKey());
                if (ccMap == null || (arg = e.getValue()) == null) continue;
                this.decreaseConcurrencyForValue(arg, ccMap);
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[ParameterMetric] Failed to decrease concurrency", e);
        }
    }

    public void decreaseThreadCount(Object ... args) {
        if (args == null) {
            return;
        }
        try {
            for (int index = 0; index < args.length; ++index) {
                Object arg;
                CacheMap<Object, AtomicInteger> ccMap = this.concurrencyMap.get(index);
                if (ccMap == null || (arg = args[index]) == null) continue;
                this.decreaseConcurrencyForValue(arg, ccMap);
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[ParameterMetric] Failed to decrease concurrency", e);
        }
    }

    private void increaseConcurrencyForValue(Object param, CacheMap<Object, AtomicInteger> ccMap) {
        if (Collection.class.isAssignableFrom(param.getClass())) {
            for (Object value : (Collection)param) {
                AtomicInteger oldValue = ccMap.putIfAbsent(value, new AtomicInteger());
                if (oldValue != null) {
                    oldValue.incrementAndGet();
                    continue;
                }
                ccMap.put(value, new AtomicInteger(1));
            }
        } else if (param.getClass().isArray()) {
            int length = Array.getLength(param);
            for (int i = 0; i < length; ++i) {
                Object value = Array.get(param, i);
                AtomicInteger oldValue = ccMap.putIfAbsent(value, new AtomicInteger());
                if (oldValue != null) {
                    oldValue.incrementAndGet();
                    continue;
                }
                ccMap.put(value, new AtomicInteger(1));
            }
        } else {
            AtomicInteger oldValue = ccMap.putIfAbsent(param, new AtomicInteger());
            if (oldValue != null) {
                oldValue.incrementAndGet();
            } else {
                ccMap.put(param, new AtomicInteger(1));
            }
        }
    }

    public void increaseConcurrency(Map<String, Object> argMap) {
        if (argMap == null || argMap.isEmpty()) {
            return;
        }
        try {
            for (Map.Entry<String, Object> e : argMap.entrySet()) {
                Object arg;
                CacheMap<Object, AtomicInteger> ccMap = this.concurrencyMap.get(e.getKey());
                if (ccMap == null || (arg = e.getValue()) == null) continue;
                this.increaseConcurrencyForValue(arg, ccMap);
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[ParameterMetric] Param exception", e);
        }
    }

    public void addThreadCount(Object ... args) {
        if (args == null) {
            return;
        }
        try {
            for (int index = 0; index < args.length; ++index) {
                Object arg;
                CacheMap<Object, AtomicInteger> ccMap = this.concurrencyMap.get(index);
                if (ccMap == null || (arg = args[index]) == null) continue;
                this.increaseConcurrencyForValue(arg, ccMap);
            }
        }
        catch (Throwable e) {
            RecordLog.warn("[ParameterMetric] Param exception", e);
        }
    }

    public long getConcurrency(String paramKey, Object paramValue) {
        CacheMap<Object, AtomicInteger> cacheMap = this.concurrencyMap.get(paramKey);
        if (cacheMap == null) {
            return 0L;
        }
        AtomicInteger count = cacheMap.get(paramValue);
        return count == null ? 0L : (long)count.get();
    }

    public long getConcurrency(int index, Object value) {
        CacheMap<Object, AtomicInteger> cacheMap = this.concurrencyMap.get(index);
        if (cacheMap == null) {
            return 0L;
        }
        AtomicInteger count = cacheMap.get(value);
        return count == null ? 0L : (long)count.get();
    }

    @Deprecated
    public long getThreadCount(int index, Object value) {
        return this.getConcurrency(index, value);
    }

    Map<ParamFlowRule, CacheMap<Object, AtomicLong>> getRuleTokenCounterMap() {
        return this.ruleTokenCounter;
    }

    Map<Object, CacheMap<Object, AtomicInteger>> getConcurrencyMap() {
        return this.concurrencyMap;
    }

    Map<ParamFlowRule, CacheMap<Object, AtomicLong>> getRuleTimeCounterMap() {
        return this.ruleTimeCounters;
    }
}

