/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.context.Context;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.DefaultNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.AbstractLinkedProcessorSlot;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowChecker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetricStorage;
import java.util.List;
import java.util.Map;

public class ParamFlowSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        if (!ParamFlowRuleManager.hasRules(resourceWrapper.getName())) {
            this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
            return;
        }
        Map<String, Object> argMap = context.getCurEntry().getArgMap();
        if (argMap != null) {
            this.checkFlow(resourceWrapper, count, argMap);
        } else {
            this.checkFlow(resourceWrapper, count, args);
        }
        this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
    }

    @Override
    public void exit(Context context, ResourceWrapper resourceWrapper, int count, Object ... args) {
        this.fireExit(context, resourceWrapper, count, args);
    }

    void applyRealParamIdx(ParamFlowRule rule, int length) {
        int paramIdx = rule.getParamIdx();
        if (paramIdx < 0) {
            if (-paramIdx <= length) {
                rule.setParamIdx(length + paramIdx);
            } else {
                rule.setParamIdx(-paramIdx);
            }
        }
    }

    void checkFlow(ResourceWrapper resourceWrapper, int count, Object ... args) throws BlockException {
        if (args == null) {
            return;
        }
        if (!ParamFlowRuleManager.hasRules(resourceWrapper.getName())) {
            return;
        }
        List<ParamFlowRule> rules = ParamFlowRuleManager.getRulesOfResource(resourceWrapper.getName());
        for (ParamFlowRule rule : rules) {
            this.applyRealParamIdx(rule, args.length);
            ParameterMetricStorage.initParamMetricsFor(resourceWrapper, rule);
            if (ParamFlowChecker.passCheck(resourceWrapper, rule, count, args)) continue;
            String triggeredParam = "";
            if (args.length > rule.getParamIdx()) {
                Object value = args[rule.getParamIdx()];
                triggeredParam = String.valueOf(value);
            }
            throw new ParamFlowException(resourceWrapper.getName(), triggeredParam, rule);
        }
    }

    void checkFlow(ResourceWrapper resourceWrapper, int count, Map<String, Object> argMap) throws BlockException {
        if (argMap == null) {
            return;
        }
        if (!ParamFlowRuleManager.hasRules(resourceWrapper.getName())) {
            return;
        }
        List<ParamFlowRule> rules = ParamFlowRuleManager.getRulesOfResource(resourceWrapper.getName());
        for (ParamFlowRule rule : rules) {
            ParameterMetricStorage.initParamMetricsFor(resourceWrapper, rule);
            if (ParamFlowChecker.passCheck(resourceWrapper, rule, count, argMap)) continue;
            String triggeredParam = rule.getParamKey();
            throw new ParamFlowException(resourceWrapper.getName(), triggeredParam, rule);
        }
    }
}

