/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.controller;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.machine.MachineGroupManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.Node;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.TrafficShapingController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Supplier;

public class GlobalToLocalRequestCountController
implements TrafficShapingController {
    private final Supplier<Integer> machineCountSupplier;
    private final double clusterThreshold;
    private final Double upperBoundLocalThreshold;
    private final Double lowerBoundLocalThreshold;
    private volatile int curMachineCount;
    private volatile double curLocalThreshold;

    public GlobalToLocalRequestCountController(double clusterThreshold, Double upperBoundLocalThreshold, Double lowerBoundLocalThreshold) {
        this(clusterThreshold, new Supplier<Integer>(){

            @Override
            public Integer get() {
                return MachineGroupManager.getMachineCount();
            }
        }, upperBoundLocalThreshold, lowerBoundLocalThreshold);
    }

    public GlobalToLocalRequestCountController(double clusterThreshold, Supplier<Integer> machineCountSupplier, Double upperBoundLocalThreshold, Double lowerBoundLocalThreshold) {
        AssertUtil.assertTrue(clusterThreshold >= 0.0, "threshold requires >= 0");
        AssertUtil.assertNotNull(machineCountSupplier, "machineCountSupplier cannot be null");
        if (upperBoundLocalThreshold != null) {
            AssertUtil.assertTrue(upperBoundLocalThreshold >= 0.0, "upperBoundLocalThreshold requires >= 0");
        }
        AssertUtil.assertTrue(lowerBoundLocalThreshold != null && lowerBoundLocalThreshold >= 0.0, "lowerBoundLocalThreshold is required and should be non-negative");
        this.clusterThreshold = clusterThreshold;
        this.machineCountSupplier = machineCountSupplier;
        this.lowerBoundLocalThreshold = lowerBoundLocalThreshold;
        this.upperBoundLocalThreshold = upperBoundLocalThreshold;
        Integer initialMachineCount = machineCountSupplier.get();
        AssertUtil.assertTrue(initialMachineCount != null && initialMachineCount > 0, "initialMachineCount from machineCountSupplier requires >= 0");
        this.refreshMachineCountAndLocalThreshold(initialMachineCount);
    }

    public double getCurLocalThreshold() {
        return this.curLocalThreshold;
    }

    protected void refreshMachineCountAndLocalThreshold(int newMachineCount) {
        if (newMachineCount >= 1) {
            this.curMachineCount = newMachineCount;
            this.curLocalThreshold = this.upperBoundLocalThreshold != null ? Math.max(Math.min(this.clusterThreshold / (double)newMachineCount, this.upperBoundLocalThreshold), this.lowerBoundLocalThreshold) : Math.max(this.clusterThreshold / (double)newMachineCount, this.lowerBoundLocalThreshold);
        }
    }

    @Override
    public boolean canPass(Node node, int acquireCount) {
        if (acquireCount <= 0) {
            return true;
        }
        if (this.clusterThreshold <= 0.0) {
            return false;
        }
        double curUsed = this.curUsedQuotaOfStatNode(node);
        Integer freshMachineCount = this.machineCountSupplier.get();
        if (freshMachineCount != null && this.curMachineCount != freshMachineCount) {
            this.refreshMachineCountAndLocalThreshold(freshMachineCount);
        }
        return curUsed + (double)acquireCount <= this.curLocalThreshold;
    }

    @Override
    public boolean canPass(Node node, int acquireCount, boolean prioritized) {
        return this.canPass(node, acquireCount);
    }

    private double curUsedQuotaOfStatNode(Node node) {
        return node == null ? 0.0 : node.passQps();
    }
}

