/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.cluster;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.TokenResult;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.TokenService;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.client.TokenClientProvider;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.common.SyncTokenRequest;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.server.EmbeddedClusterTokenServerProvider;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.cluster.stat.ClusterFlowBatchStat;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.machine.MachineGroupManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.ClusterFlowConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.FlowRuleChecker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.TimeUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Tuple2;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ClusterTokenRequestCollapser {
    private static volatile Map<Long, BatchFlowSingleBucketSlidingWindow> statMap = new HashMap<Long, BatchFlowSingleBucketSlidingWindow>();
    private static ExecutorService pool;
    private static volatile boolean taskEnabled;
    private static final Object LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleBatchStatChange(Set<Tuple2<Long, FlowRule>> newSet) {
        if (newSet == null || newSet.isEmpty()) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            HashMap<Long, BatchFlowSingleBucketSlidingWindow> oldMap = new HashMap<Long, BatchFlowSingleBucketSlidingWindow>(statMap);
            HashMap<Long, BatchFlowSingleBucketSlidingWindow> newMap = new HashMap<Long, BatchFlowSingleBucketSlidingWindow>(statMap.size());
            for (Tuple2<Long, FlowRule> toAdd : newSet) {
                BatchFlowSingleBucketSlidingWindow w = (BatchFlowSingleBucketSlidingWindow)oldMap.get(toAdd.r1);
                FlowRule rule = (FlowRule)toAdd.r2;
                if (w != null && w.getRule().equals(rule)) {
                    newMap.put((Long)toAdd.r1, w);
                    continue;
                }
                newMap.put((Long)toAdd.r1, new BatchFlowSingleBucketSlidingWindow(rule));
            }
            statMap = newMap;
        }
    }

    static void stopSendTask() {
        taskEnabled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean tryAcquireToken(Long id, int acquireCount) {
        BatchFlowSingleBucketSlidingWindow w = statMap.get(id);
        if (w == null || !taskEnabled) {
            return null;
        }
        ClusterFlowBatchStat stat = (ClusterFlowBatchStat)w.currentWindow().value();
        long curRemaining = stat.getRemainingCount();
        try {
            if (curRemaining - (long)stat.getOccupied().get() >= (long)acquireCount) {
                stat.getOccupied().addAndGet(acquireCount);
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            ClusterTokenRequestCollapser.scheduleTokenRequestIfNeeded(id, w, stat);
        }
    }

    private static void scheduleTokenRequestIfNeeded(Long id, BatchFlowSingleBucketSlidingWindow w, ClusterFlowBatchStat stat) {
        try {
            int latchCount = ClusterTokenRequestCollapser.getMaxLocalLatchAmount(w.rule);
            if ((TimeUtil.currentTimeMillis() >= w.nextSyncTimestamp || stat.getOccupied().get() >= latchCount) && w.pendingSync.compareAndSet(false, true)) {
                long start = TimeUtil.currentTimeMillis();
                w.nextSyncTimestamp = start + (long)ClusterTokenRequestCollapser.calculateNextWaitMs(w.rule, latchCount);
                boolean submitted = ClusterTokenRequestCollapser.submitSyncTokenTask(id, w);
                if (!submitted) {
                    w.markSyncAvailable();
                }
            }
        }
        catch (Throwable t) {
            w.markSyncAvailable();
            RecordLog.error("[ClusterTokenRequestCollapser] Failed to submitSyncTokenTask, ruleId={}", id, t);
        }
    }

    private static int calculateNextWaitMs(FlowRule rule, int latchCount) {
        if (latchCount < 200) {
            return ThreadLocalRandom.current().nextInt(20, 50);
        }
        if (latchCount >= 200 && latchCount < 400) {
            return ThreadLocalRandom.current().nextInt(20, 40);
        }
        return ThreadLocalRandom.current().nextInt(20, 30);
    }

    private static int getMaxLocalLatchAmount(FlowRule rule) {
        double fallbackThreshold = rule.getCount();
        int machineCount = MachineGroupManager.getMachineCount();
        ClusterFlowConfig c = rule.getClusterConfig();
        if (c.getThresholdType() == 0) {
            if (c.getFallbackThreshold() != null) {
                fallbackThreshold = c.getFallbackThreshold().intValue();
            }
        } else if (machineCount >= 1) {
            fallbackThreshold = Math.round(rule.getCount() / (double)machineCount);
        } else if (c.getFallbackThreshold() != null) {
            fallbackThreshold = c.getFallbackThreshold().intValue();
        }
        return fallbackThreshold > 500.0 ? 500 : Math.max((int)fallbackThreshold - 5, 10);
    }

    private static boolean submitSyncTokenTask(final Long ruleId, final BatchFlowSingleBucketSlidingWindow w) {
        final TokenService tokenService = FlowRuleChecker.pickClusterService();
        if (tokenService == null || pool == null) {
            return false;
        }
        WindowWrap prevBucket = w.currentWindow();
        final long lastBucketStart = prevBucket.windowStart();
        final int beforeOccupied = ((ClusterFlowBatchStat)prevBucket.value()).getOccupied().get();
        pool.submit(new Runnable(){

            @Override
            public void run() {
                ClusterTokenRequestCollapser.doSyncTokenFor(ruleId, w, tokenService, lastBucketStart, beforeOccupied);
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSyncTokenFor(Long ruleId, BatchFlowSingleBucketSlidingWindow w, TokenService tokenService, long lastBucketStart, int beforeOccupied) {
        try {
            long sendTime = TimeUtil.currentTimeMillis();
            SyncTokenRequest request = new SyncTokenRequest().setRuleId(ruleId).setBatchCount(beforeOccupied).setAllowPartialAcq(true).setCurMillis(sendTime);
            int timeoutMs = ClusterTokenRequestCollapser.intOrDefault(w.getRule().getClusterConfig().getRequestTimeout(), 0);
            TokenResult result = tokenService.syncToken(request, timeoutMs);
            if (ClusterTokenRequestCollapser.isResultFailed(result)) {
                if (result.getStatus() == -1) {
                    ClusterTokenRequestCollapser.handleRequestTimeout(ruleId, w, lastBucketStart);
                }
                RecordLog.warn("[CLUSTER-BATCH] Request failed, ruleId={}, result={}", ruleId, result.toString());
                return;
            }
            long recvTime = TimeUtil.currentTimeMillis();
            WindowWrap curBucket = w.currentWindow();
            int clusterRemaining = result.getRemaining();
            if (curBucket.windowStart() > lastBucketStart) {
                ((ClusterFlowBatchStat)curBucket.value()).getOccupied().set(0);
                return;
            }
            Long bucketStartOfServer = (Long)result.getAttachment("bucketStartOfServer");
            long curBucketStart = curBucket.windowStart();
            if (bucketStartOfServer != null && curBucketStart > bucketStartOfServer) {
                return;
            }
            int deltaOccupied = Math.max(((ClusterFlowBatchStat)curBucket.value()).getOccupied().get() - beforeOccupied, 0);
            ((ClusterFlowBatchStat)curBucket.value()).reset(clusterRemaining, deltaOccupied);
        }
        catch (Throwable t) {
            RecordLog.error("[CLUSTER-BATCH] Failed to syncToken and update quota, ruleId={}", ruleId, t);
        }
        finally {
            w.markSyncAvailable();
        }
    }

    private static void handleRequestTimeout(Long ruleId, BatchFlowSingleBucketSlidingWindow w, long prevBucketStart) {
        long t = TimeUtil.currentTimeMillis();
        ClusterFlowBatchStat stat = (ClusterFlowBatchStat)w.currentWindow().value();
        if (w.currentWindow().windowStart() > prevBucketStart) {
            return;
        }
        long beforeRemaining = stat.getRemainingCount();
        stat.reset(Math.max(0L, stat.getRemainingCount() - (long)stat.getOccupied().get()), 0);
    }

    private static boolean isResultFailed(TokenResult result) {
        return result.getStatus() <= -1 || result.getStatus() == 3;
    }

    private static int intOrDefault(Integer i, int defaultValue) {
        return i != null ? i : defaultValue;
    }

    private static void silentSleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private ClusterTokenRequestCollapser() {
    }

    static {
        taskEnabled = false;
        LOCK = new Object();
        try {
            if (TokenClientProvider.getClient() != null || EmbeddedClusterTokenServerProvider.getServer() != null) {
                pool = new ThreadPoolExecutor(8, 8, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(64), new NamedThreadFactory("sentinel-cluster-token-batch-request-task", true), new RejectedExecutionHandler(){

                    @Override
                    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                        if (!e.isShutdown()) {
                            RecordLog.warn("[ClusterTokenRequestCollapser] SyncToken task pool full, discarding oldest", new Object[0]);
                            e.getQueue().poll();
                            e.execute(r);
                        }
                    }
                });
                taskEnabled = true;
                RecordLog.info("[ClusterTokenRequestCollapser] Cluster flow batch request sender task started", new Object[0]);
            }
        }
        catch (Throwable t) {
            RecordLog.error("Failed to initialize ClusterTokenRequestCollapser", t);
        }
    }

    static class BatchFlowSingleBucketSlidingWindow
    extends LeapArray<ClusterFlowBatchStat> {
        private final FlowRule rule;
        private final long fullCount;
        private final AtomicBoolean pendingSync = new AtomicBoolean(false);
        private volatile long nextSyncTimestamp = 0L;

        public BatchFlowSingleBucketSlidingWindow(FlowRule rule) {
            super(1, rule.getClusterConfig().getWindowIntervalMs());
            this.rule = rule;
            int thresholdType = rule.getClusterConfig().getThresholdType();
            this.fullCount = thresholdType == 1 ? (long)rule.getCount() : Integer.MAX_VALUE;
        }

        @Override
        public ClusterFlowBatchStat newEmptyBucket(long timeMillis) {
            return new ClusterFlowBatchStat().reset(this.fullCount);
        }

        @Override
        protected WindowWrap<ClusterFlowBatchStat> resetWindowTo(WindowWrap<ClusterFlowBatchStat> b, long startTime) {
            b.resetTo(startTime);
            b.value().reset(this.fullCount);
            return b;
        }

        public FlowRule getRule() {
            return this.rule;
        }

        public AtomicBoolean getPendingSync() {
            return this.pendingSync;
        }

        public long getNextSyncTimestamp() {
            return this.nextSyncTimestamp;
        }

        BatchFlowSingleBucketSlidingWindow setNextSyncTimestamp(long nextSyncTimestamp) {
            this.nextSyncTimestamp = nextSyncTimestamp;
            return this;
        }

        boolean markSyncAvailable() {
            return this.pendingSync.compareAndSet(true, false);
        }
    }
}

