/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.ClusterFlowConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.ColdFactorProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.FlowRuleComparator;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.TrafficShapingController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.controller.DefaultConcurrencyController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.controller.DefaultRequestCountController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.controller.GlobalToLocalRequestCountController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.controller.RateLimiterController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.controller.WarmUpController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.controller.WarmUpRateLimiterController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Function;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class FlowRuleUtil {
    private static final Function<FlowRule, String> extractResource = new Function<FlowRule, String>(){

        @Override
        public String apply(FlowRule rule) {
            return rule.getResource();
        }
    };

    public static Map<String, List<FlowRule>> buildFlowRuleMap(List<FlowRule> list) {
        return FlowRuleUtil.buildFlowRuleMap(list, null);
    }

    public static Map<String, List<FlowRule>> buildFlowRuleMap(List<FlowRule> list, Predicate<FlowRule> filter) {
        return FlowRuleUtil.buildFlowRuleMap(list, filter, true);
    }

    public static Map<String, List<FlowRule>> buildFlowRuleMap(List<FlowRule> list, Predicate<FlowRule> filter, boolean shouldSort) {
        return FlowRuleUtil.buildFlowRuleMap(list, extractResource, filter, shouldSort);
    }

    public static <K> Map<K, List<FlowRule>> buildFlowRuleMap(List<FlowRule> list, Function<FlowRule, K> groupFunction, Predicate<FlowRule> filter, boolean shouldSort) {
        HashMap newRuleMap = new HashMap();
        if (list == null || list.isEmpty()) {
            return newRuleMap;
        }
        HashMap<K, HashSet<FlowRule>> tmpMap = new HashMap<K, HashSet<FlowRule>>();
        for (FlowRule rule : list) {
            if (!FlowRuleUtil.isValidRule(rule)) {
                RecordLog.warn("[FlowRuleManager] Ignoring invalid flow rule when loading new flow rules: " + rule, new Object[0]);
                continue;
            }
            if (filter != null && !filter.test(rule)) continue;
            if (StringUtil.isBlank(rule.getLimitApp())) {
                rule.setLimitApp("default");
            }
            TrafficShapingController rater = FlowRuleUtil.generateRater(rule);
            rule.setRater(rater);
            K key = groupFunction.apply(rule);
            if (key == null) continue;
            HashSet<FlowRule> flowRules = (HashSet<FlowRule>)tmpMap.get(key);
            if (flowRules == null) {
                flowRules = new HashSet<FlowRule>();
                tmpMap.put(key, flowRules);
            }
            flowRules.add(rule);
        }
        FlowRuleComparator comparator = new FlowRuleComparator();
        for (Map.Entry entries : tmpMap.entrySet()) {
            ArrayList rules = new ArrayList((Collection)entries.getValue());
            if (shouldSort) {
                Collections.sort(rules, comparator);
            }
            newRuleMap.put(entries.getKey(), rules);
        }
        return newRuleMap;
    }

    private static TrafficShapingController generateRater(FlowRule rule) {
        int metricType = rule.getGrade();
        if (metricType == 0) {
            return new DefaultConcurrencyController((long)Math.floor(rule.getCount()));
        }
        if (metricType == 1) {
            switch (rule.getControlBehavior()) {
                case 1: {
                    return new WarmUpController(rule.getCount(), rule.getWarmUpPeriodSec(), ColdFactorProperty.coldFactor);
                }
                case 2: {
                    return new RateLimiterController(rule.getMaxQueueingTimeMs(), rule.getCount());
                }
                case 3: {
                    return new WarmUpRateLimiterController(rule.getCount(), rule.getWarmUpPeriodSec(), rule.getMaxQueueingTimeMs(), ColdFactorProperty.coldFactor);
                }
                case 0: {
                    if (rule.getThresholdMode() == 2) {
                        return new GlobalToLocalRequestCountController(rule.getCount(), rule.getUpperBoundThreshold(), rule.getLowerBoundThreshold());
                    }
                    return new DefaultRequestCountController(rule.getCount(), rule.getStatDurationMs(), rule.isStrictModeEnabled());
                }
            }
        }
        return new DefaultRequestCountController(rule.getCount(), rule.getStatDurationMs(), rule.isStrictModeEnabled());
    }

    public static boolean validClusterRuleId(Long id) {
        return id != null && id > 0L;
    }

    public static boolean isValidRule(FlowRule rule) {
        boolean baseValid;
        boolean bl = baseValid = rule != null && !StringUtil.isBlank(rule.getResource()) && rule.getCount() >= 0.0 && rule.getGrade() >= 0 && rule.getStrategy() >= 0 && rule.getControlBehavior() >= 0;
        if (!baseValid) {
            return false;
        }
        if (rule.getStatDurationMs() <= 0L) {
            return false;
        }
        return FlowRuleUtil.checkClusterField(rule) && FlowRuleUtil.checkThresholdMode(rule) && FlowRuleUtil.checkStrategyField(rule) && FlowRuleUtil.checkControlBehaviorField(rule);
    }

    private static boolean checkThresholdMode(FlowRule rule) {
        int thresholdMode = rule.getThresholdMode();
        if (thresholdMode < 0) {
            return false;
        }
        if (thresholdMode == 2) {
            Double ub = rule.getUpperBoundThreshold();
            Double lb = rule.getLowerBoundThreshold();
            if (lb == null || lb < 0.0) {
                return false;
            }
            if (ub != null && ub < 0.0) {
                return false;
            }
            if (ub != null && lb > ub) {
                return false;
            }
        }
        return true;
    }

    private static boolean checkClusterField(FlowRule rule) {
        boolean globalMode;
        if (!rule.isClusterMode()) {
            return true;
        }
        ClusterFlowConfig clusterConfig = rule.getClusterConfig();
        if (clusterConfig == null) {
            return false;
        }
        if (!FlowRuleUtil.validClusterRuleId(clusterConfig.getFlowId())) {
            return false;
        }
        if (!FlowRuleUtil.isWindowConfigValid(clusterConfig.getSampleCount(), clusterConfig.getWindowIntervalMs())) {
            return false;
        }
        Integer requestTimeout = clusterConfig.getRequestTimeout();
        if (requestTimeout != null && requestTimeout <= 0) {
            return false;
        }
        boolean bl = globalMode = clusterConfig.getThresholdType() == 1;
        if (clusterConfig.isFallbackToLocalWhenFail()) {
            if (clusterConfig.isAutoAdjustFallbackThresholdEnabled()) {
                if (clusterConfig.getFallbackThresholdAdjustMargin() != null && clusterConfig.getFallbackThresholdAdjustMargin() < 0) {
                    return false;
                }
            } else {
                if (globalMode && clusterConfig.getFallbackThreshold() == null && clusterConfig.getFallbackThresholdAdjustMargin() == null) {
                    return false;
                }
                if (clusterConfig.getFallbackThreshold() != null && clusterConfig.getFallbackThreshold() < 0) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isWindowConfigValid(int sampleCount, int windowIntervalMs) {
        return sampleCount > 0 && windowIntervalMs > 0 && windowIntervalMs % sampleCount == 0;
    }

    private static boolean checkStrategyField(FlowRule rule) {
        if (rule.getStrategy() == 1 || rule.getStrategy() == 2) {
            return StringUtil.isNotBlank(rule.getRefResource());
        }
        return true;
    }

    private static boolean checkControlBehaviorField(FlowRule rule) {
        switch (rule.getControlBehavior()) {
            case 1: {
                return rule.getWarmUpPeriodSec() > 0;
            }
            case 2: {
                return rule.getMaxQueueingTimeMs() > 0;
            }
            case 3: {
                return rule.getWarmUpPeriodSec() > 0 && rule.getMaxQueueingTimeMs() > 0;
            }
        }
        return true;
    }

    private FlowRuleUtil() {
    }
}

