/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.log.block.BlockLogAggregatorTask;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricAggregatorTask;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.PropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.FlowRuleUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.cluster.ClusterTokenRequestCollapser;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class FlowRuleManager {
    private static volatile Map<String, List<FlowRule>> flowRules = new HashMap<String, List<FlowRule>>();
    private static final FlowPropertyListener LISTENER = new FlowPropertyListener();
    private static SentinelProperty<List<FlowRule>> currentProperty = new DynamicSentinelProperty<List<FlowRule>>();
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(2, new NamedThreadFactory("sentinel-metric-aggregator-task", true));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<FlowRule>> property) {
        AssertUtil.notNull(property, "property cannot be null");
        FlowPropertyListener flowPropertyListener = LISTENER;
        synchronized (flowPropertyListener) {
            RecordLog.info("[FlowRuleManager] Registering new property to flow rule manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    public static List<FlowRule> getRules() {
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        for (Map.Entry<String, List<FlowRule>> entry : flowRules.entrySet()) {
            rules.addAll((Collection<FlowRule>)entry.getValue());
        }
        return rules;
    }

    public static void loadRules(List<FlowRule> rules) {
        currentProperty.updateValue(rules);
    }

    static Map<String, List<FlowRule>> getFlowRuleMap() {
        return flowRules;
    }

    public static boolean hasConfig(String resource) {
        return flowRules.containsKey(resource);
    }

    public static boolean isOtherOrigin(String origin, String resourceName) {
        if (StringUtil.isEmpty(origin)) {
            return false;
        }
        List<FlowRule> rules = flowRules.get(resourceName);
        if (rules != null) {
            for (FlowRule rule : rules) {
                if (!origin.equals(rule.getLimitApp())) continue;
                return false;
            }
        }
        return true;
    }

    static {
        currentProperty.addListener(LISTENER);
        try {
            int metricInterval = SentinelConfig.metricLogFlushIntervalSec();
            if (metricInterval > 0) {
                SCHEDULER.scheduleAtFixedRate(new MetricAggregatorTask(), 0L, metricInterval, TimeUnit.SECONDS);
                SCHEDULER.scheduleAtFixedRate(new BlockLogAggregatorTask(), 0L, metricInterval, TimeUnit.SECONDS);
            }
        }
        catch (Throwable t) {
            RecordLog.warn("[FlowRuleManager] Failed to initialize metric log task", t);
        }
    }

    private static final class FlowPropertyListener
    implements PropertyListener<List<FlowRule>> {
        private FlowPropertyListener() {
        }

        private Set<Tuple2<Long, FlowRule>> filterBatchClusterFlowRules(Map<String, List<FlowRule>> ruleMap) {
            HashSet<Tuple2<Long, FlowRule>> rules = new HashSet<Tuple2<Long, FlowRule>>();
            if (ruleMap.isEmpty()) {
                return rules;
            }
            for (Map.Entry<String, List<FlowRule>> e : ruleMap.entrySet()) {
                for (FlowRule r : e.getValue()) {
                    if (!r.isClusterMode() || r.getClusterConfig().getRequestMode() != 1) continue;
                    rules.add(Tuple2.of(r.getClusterConfig().getFlowId(), r));
                }
            }
            return rules;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<String, List<FlowRule>> updateRuleMap(List<FlowRule> conf) {
            Map<String, List<FlowRule>> ruleMap = FlowRuleUtil.buildFlowRuleMap(conf);
            FlowPropertyListener flowPropertyListener = LISTENER;
            synchronized (flowPropertyListener) {
                ClusterTokenRequestCollapser.handleBatchStatChange(this.filterBatchClusterFlowRules(ruleMap));
                flowRules = ruleMap;
            }
            return ruleMap;
        }

        @Override
        public void configUpdate(List<FlowRule> conf) {
            Map<String, List<FlowRule>> ruleMap = this.updateRuleMap(conf);
            RecordLog.info("[FlowRuleManager] Flow rules received: " + ruleMap, new Object[0]);
        }

        @Override
        public void configLoad(List<FlowRule> conf) {
            Map<String, List<FlowRule>> ruleMap = this.updateRuleMap(conf);
            RecordLog.info("[FlowRuleManager] Flow rules loaded: " + ruleMap, new Object[0]);
        }
    }
}

