/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.AbstractRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.ClusterFlowConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.TrafficShapingController;

public class FlowRule
extends AbstractRule {
    private int grade = 1;
    private double count;
    private int thresholdMode = 0;
    private Double upperBoundThreshold;
    private Double lowerBoundThreshold;
    private int strategy = 0;
    private String refResource;
    private int controlBehavior = 0;
    private int warmUpPeriodSec = 10;
    private int maxQueueingTimeMs = 500;
    private boolean clusterMode;
    private ClusterFlowConfig clusterConfig;
    private long statDurationMs = 1000L;
    private boolean strictModeEnabled = false;
    private TrafficShapingController controller;

    public FlowRule() {
        this.setLimitApp("default");
    }

    public FlowRule(String resourceName) {
        this.setResource(resourceName);
        this.setLimitApp("default");
    }

    public int getControlBehavior() {
        return this.controlBehavior;
    }

    public FlowRule setControlBehavior(int controlBehavior) {
        this.controlBehavior = controlBehavior;
        return this;
    }

    public int getMaxQueueingTimeMs() {
        return this.maxQueueingTimeMs;
    }

    public FlowRule setMaxQueueingTimeMs(int maxQueueingTimeMs) {
        this.maxQueueingTimeMs = maxQueueingTimeMs;
        return this;
    }

    FlowRule setRater(TrafficShapingController rater) {
        this.controller = rater;
        return this;
    }

    TrafficShapingController getRater() {
        return this.controller;
    }

    public int getWarmUpPeriodSec() {
        return this.warmUpPeriodSec;
    }

    public FlowRule setWarmUpPeriodSec(int warmUpPeriodSec) {
        this.warmUpPeriodSec = warmUpPeriodSec;
        return this;
    }

    public int getGrade() {
        return this.grade;
    }

    public FlowRule setGrade(int grade) {
        this.grade = grade;
        return this;
    }

    public double getCount() {
        return this.count;
    }

    public FlowRule setCount(double count) {
        this.count = count;
        return this;
    }

    public int getThresholdMode() {
        return this.thresholdMode;
    }

    public FlowRule setThresholdMode(int thresholdMode) {
        this.thresholdMode = thresholdMode;
        return this;
    }

    public Double getUpperBoundThreshold() {
        return this.upperBoundThreshold;
    }

    public FlowRule setUpperBoundThreshold(Double upperBoundThreshold) {
        this.upperBoundThreshold = upperBoundThreshold;
        return this;
    }

    public Double getLowerBoundThreshold() {
        return this.lowerBoundThreshold;
    }

    public FlowRule setLowerBoundThreshold(Double lowerBoundThreshold) {
        this.lowerBoundThreshold = lowerBoundThreshold;
        return this;
    }

    public int getStrategy() {
        return this.strategy;
    }

    public FlowRule setStrategy(int strategy) {
        this.strategy = strategy;
        return this;
    }

    public String getRefResource() {
        return this.refResource;
    }

    public FlowRule setRefResource(String refResource) {
        this.refResource = refResource;
        return this;
    }

    public boolean isClusterMode() {
        return this.clusterMode;
    }

    public FlowRule setClusterMode(boolean clusterMode) {
        this.clusterMode = clusterMode;
        return this;
    }

    public ClusterFlowConfig getClusterConfig() {
        return this.clusterConfig;
    }

    public FlowRule setClusterConfig(ClusterFlowConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
        return this;
    }

    public long getStatDurationMs() {
        return this.statDurationMs;
    }

    public FlowRule setStatDurationMs(long statDurationMs) {
        this.statDurationMs = statDurationMs;
        return this;
    }

    public boolean isStrictModeEnabled() {
        return this.strictModeEnabled;
    }

    public FlowRule setStrictModeEnabled(boolean strictModeEnabled) {
        this.strictModeEnabled = strictModeEnabled;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FlowRule flowRule = (FlowRule)o;
        if (this.grade != flowRule.grade) {
            return false;
        }
        if (Double.compare(flowRule.count, this.count) != 0) {
            return false;
        }
        if (this.thresholdMode != flowRule.thresholdMode) {
            return false;
        }
        if (this.upperBoundThreshold != null ? !this.upperBoundThreshold.equals(flowRule.upperBoundThreshold) : flowRule.upperBoundThreshold != null) {
            return false;
        }
        if (this.lowerBoundThreshold != null ? !this.lowerBoundThreshold.equals(flowRule.lowerBoundThreshold) : flowRule.lowerBoundThreshold != null) {
            return false;
        }
        if (this.strategy != flowRule.strategy) {
            return false;
        }
        if (this.controlBehavior != flowRule.controlBehavior) {
            return false;
        }
        if (this.warmUpPeriodSec != flowRule.warmUpPeriodSec) {
            return false;
        }
        if (this.maxQueueingTimeMs != flowRule.maxQueueingTimeMs) {
            return false;
        }
        if (this.clusterMode != flowRule.clusterMode) {
            return false;
        }
        if (this.statDurationMs != flowRule.statDurationMs) {
            return false;
        }
        if (this.strictModeEnabled != flowRule.strictModeEnabled) {
            return false;
        }
        if (this.refResource != null ? !this.refResource.equals(flowRule.refResource) : flowRule.refResource != null) {
            return false;
        }
        return this.clusterConfig != null ? this.clusterConfig.equals(flowRule.clusterConfig) : flowRule.clusterConfig == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.grade;
        long temp = Double.doubleToLongBits(this.count);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.thresholdMode;
        temp = Double.doubleToLongBits(this.upperBoundThreshold != null ? (double)this.upperBoundThreshold.hashCode() : 0.0);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lowerBoundThreshold != null ? (double)this.lowerBoundThreshold.hashCode() : 0.0);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.strategy;
        result = 31 * result + (this.refResource != null ? this.refResource.hashCode() : 0);
        result = 31 * result + this.controlBehavior;
        result = 31 * result + this.warmUpPeriodSec;
        result = 31 * result + this.maxQueueingTimeMs;
        result = 31 * result + (this.clusterMode ? 1 : 0);
        result = 31 * result + (this.clusterConfig != null ? this.clusterConfig.hashCode() : 0);
        result = 31 * result + (int)(this.statDurationMs ^ this.statDurationMs >>> 32);
        result = 31 * result + (this.strictModeEnabled ? 1 : 0);
        return result;
    }

    public String toString() {
        return "FlowRule{resource=" + this.getResource() + ", grade=" + this.grade + ", count=" + this.count + ", thresholdMode=" + this.thresholdMode + ", upperBoundThreshold=" + this.upperBoundThreshold + ", lowerBoundThreshold=" + this.lowerBoundThreshold + ", strategy=" + this.strategy + ", refResource='" + this.refResource + '\'' + ", controlBehavior=" + this.controlBehavior + ", warmUpPeriodSec=" + this.warmUpPeriodSec + ", maxQueueingTimeMs=" + this.maxQueueingTimeMs + ", clusterMode=" + this.clusterMode + ", clusterConfig=" + this.clusterConfig + ", statDurationMs=" + this.statDurationMs + ", strictModeEnabled=" + this.strictModeEnabled + ", controller=" + this.controller + '}';
    }
}

