/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.AbstractRatioBasedCircuitBreaker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;

public class ExceptionRatioCircuitBreaker
extends AbstractRatioBasedCircuitBreaker {
    private final int minRequestAmount;
    private final LeapArray<SimpleErrorCounter> stat;

    public ExceptionRatioCircuitBreaker(DegradeRule rule) {
        this(rule, new SimpleErrorCounterLeapArray(1, rule.getStatIntervalMs()));
    }

    ExceptionRatioCircuitBreaker(DegradeRule rule, LeapArray<SimpleErrorCounter> stat) {
        super(rule, rule.getCount());
        AssertUtil.isTrue(rule.getGrade() == 1, "rule metric type should be error-ratio");
        AssertUtil.notNull(stat, "stat cannot be null");
        this.minRequestAmount = rule.getMinRequestAmount();
        this.stat = stat;
    }

    @Override
    protected void resetStat() {
        this.stat.currentWindow().value().reset();
        this.curCompleteAmountDuringRecovery.set(0);
        this.curPassAmountDuringRecovery.set(1);
    }

    @Override
    public void onRequestComplete(long rt, Throwable error) {
        SimpleErrorCounter counter = this.stat.currentWindow().value();
        if (error != null) {
            counter.getErrorCount().add(1L);
        }
        counter.getTotalCount().add(1L);
        this.handleStateChangeWhenThresholdExceeded(error);
    }

    private void handleStateChangeWhenThresholdExceeded(Throwable error) {
        if (this.currentState.get() == CircuitBreaker.State.OPEN) {
            return;
        }
        List<SimpleErrorCounter> counters = this.stat.values();
        long errCount = 0L;
        long totalCount = 0L;
        for (SimpleErrorCounter counter : counters) {
            errCount += counter.errorCount.sum();
            totalCount += counter.totalCount.sum();
        }
        if (this.currentState.get() == CircuitBreaker.State.HALF_OPEN) {
            this.handleStateChangeToHalfOpenWhenThresholdExceeded(errCount, totalCount);
            return;
        }
        if (totalCount < (long)this.minRequestAmount) {
            return;
        }
        double currentRatio = (double)errCount * 1.0 / (double)totalCount;
        if (currentRatio >= this.ratioThreshold) {
            this.transformToOpen(currentRatio);
        }
    }

    static class SimpleErrorCounterLeapArray
    extends LeapArray<SimpleErrorCounter> {
        public SimpleErrorCounterLeapArray(int sampleCount, int intervalInMs) {
            super(sampleCount, intervalInMs);
        }

        @Override
        public SimpleErrorCounter newEmptyBucket(long timeMillis) {
            return new SimpleErrorCounter();
        }

        @Override
        protected WindowWrap<SimpleErrorCounter> resetWindowTo(WindowWrap<SimpleErrorCounter> w, long startTime) {
            w.resetTo(startTime);
            w.value().reset();
            return w;
        }
    }

    static class SimpleErrorCounter {
        private LongAdder errorCount = new LongAdder();
        private LongAdder totalCount = new LongAdder();

        public LongAdder getErrorCount() {
            return this.errorCount;
        }

        public LongAdder getTotalCount() {
            return this.totalCount;
        }

        public SimpleErrorCounter reset() {
            this.errorCount.reset();
            this.totalCount.reset();
            return this;
        }

        public String toString() {
            return "SimpleErrorCounter{errorCount=" + this.errorCount + ", totalCount=" + this.totalCount + '}';
        }
    }
}

