/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.Entry;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.context.Context;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.AbstractCircuitBreaker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreakerStateChangeObserver;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.EventObserverRegistry;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.BiConsumer;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractRatioBasedCircuitBreaker
extends AbstractCircuitBreaker {
    protected final double ratioThreshold;
    protected final int halfOpenBaseAmountPerStep;
    protected final int halfOpenRecoveryStepNum;
    protected AtomicInteger curPassAmountDuringRecovery = new AtomicInteger(0);
    protected AtomicInteger curCompleteAmountDuringRecovery = new AtomicInteger(0);

    public AbstractRatioBasedCircuitBreaker(DegradeRule rule, double ratioThreshold) {
        this(rule, ratioThreshold, EventObserverRegistry.getInstance());
    }

    AbstractRatioBasedCircuitBreaker(DegradeRule rule, double ratioThreshold, EventObserverRegistry observerRegistry) {
        super(rule, observerRegistry);
        this.ratioThreshold = ratioThreshold;
        this.halfOpenBaseAmountPerStep = rule.getHalfOpenBaseAmountPerStep();
        this.halfOpenRecoveryStepNum = rule.getHalfOpenRecoveryStepNum();
    }

    @Override
    public boolean tryPass(Context context) {
        if (this.currentState.get() == CircuitBreaker.State.CLOSED) {
            return true;
        }
        if (this.currentState.get() == CircuitBreaker.State.OPEN) {
            return this.retryTimeoutArrived() && this.fromOpenToHalfOpen(context);
        }
        if (this.currentState.get() == CircuitBreaker.State.HALF_OPEN) {
            boolean permitted;
            int completeStep;
            int passStep = this.curPassAmountDuringRecovery.get() / this.halfOpenBaseAmountPerStep + 1;
            if (passStep > (completeStep = this.curCompleteAmountDuringRecovery.get() / this.halfOpenBaseAmountPerStep + 1)) {
                return false;
            }
            if (passStep == this.halfOpenRecoveryStepNum) {
                this.addPassAmountDuringRecovery(context);
                return true;
            }
            if (passStep > this.halfOpenRecoveryStepNum) {
                return false;
            }
            int upperBound = passStep * 100 / this.halfOpenRecoveryStepNum;
            boolean bl = permitted = ThreadLocalRandom.current().nextInt(0, 100) <= upperBound;
            if (permitted) {
                this.addPassAmountDuringRecovery(context);
            }
            return permitted;
        }
        return false;
    }

    protected boolean fromOpenToHalfOpen(Context context) {
        if (this.currentState.compareAndSet(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN)) {
            this.resetStat();
            for (CircuitBreakerStateChangeObserver observer : this.observerRegistry.getStateChangeObservers()) {
                observer.onStateChange(CircuitBreaker.State.OPEN, CircuitBreaker.State.HALF_OPEN, this.rule, null);
            }
            if (context != null && context.getCurEntry() != null) {
                context.getCurEntry().whenTerminate(new BiConsumer<Context, Entry>(){

                    @Override
                    public void accept(Context context, Entry entry) {
                        if (entry.getBlockError() != null) {
                            AbstractRatioBasedCircuitBreaker.this.currentState.compareAndSet(CircuitBreaker.State.HALF_OPEN, CircuitBreaker.State.OPEN);
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    private void addPassAmountDuringRecovery(Context context) {
        this.curPassAmountDuringRecovery.incrementAndGet();
        if (context != null && context.getCurEntry() != null) {
            context.getCurEntry().whenTerminate(new BiConsumer<Context, Entry>(){

                @Override
                public void accept(Context context, Entry entry) {
                    if (entry.getBlockError() != null) {
                        AbstractRatioBasedCircuitBreaker.this.curPassAmountDuringRecovery.decrementAndGet();
                    }
                }
            });
        }
    }

    protected void handleStateChangeToHalfOpenWhenThresholdExceeded(long triggerCount, long totalCount) {
        int totalRecovery = this.curCompleteAmountDuringRecovery.incrementAndGet();
        if (totalRecovery % this.halfOpenBaseAmountPerStep == 0) {
            double currentRatio = (double)triggerCount * 1.0 / (double)totalCount;
            if (currentRatio > this.ratioThreshold) {
                this.transformToOpen(currentRatio);
            } else if (totalRecovery / this.halfOpenBaseAmountPerStep == this.halfOpenRecoveryStepNum) {
                this.fromHalfOpenToClose();
            }
        }
    }
}

