/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SimplePropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.ManualDegradeRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManualDegradeRuleManager {
    private volatile Map<String, ManualDegradeRule> ruleMap = new HashMap<String, ManualDegradeRule>();
    private SentinelProperty<List<ManualDegradeRule>> currentProperty = new DynamicSentinelProperty<List<ManualDegradeRule>>();
    private final ManualDegradeRulePropertyListener propertyListener = new ManualDegradeRulePropertyListener();

    protected ManualDegradeRuleManager() {
        this.currentProperty.addListener(this.propertyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register2Property(SentinelProperty<List<ManualDegradeRule>> property) {
        AssertUtil.notNull(property, "property cannot be null");
        ManualDegradeRulePropertyListener manualDegradeRulePropertyListener = this.propertyListener;
        synchronized (manualDegradeRulePropertyListener) {
            RecordLog.info("[ManualDegradeRuleManager] Registering new property to manual degrade rule manager", new Object[0]);
            this.currentProperty.removeListener(this.propertyListener);
            property.addListener(this.propertyListener);
            this.currentProperty = property;
        }
    }

    public boolean loadRules(List<ManualDegradeRule> rules) {
        return this.currentProperty.updateValue(rules);
    }

    public List<ManualDegradeRule> getRules() {
        ArrayList<ManualDegradeRule> list = new ArrayList<ManualDegradeRule>();
        for (Map.Entry<String, ManualDegradeRule> e : this.ruleMap.entrySet()) {
            if (e.getValue() == null) continue;
            list.add(e.getValue());
        }
        return list;
    }

    public ManualDegradeRule getRuleOfResource(String resource) {
        if (resource == null) {
            return null;
        }
        return this.ruleMap.get(resource);
    }

    public static boolean isValidRule(ManualDegradeRule rule) {
        return rule != null && !StringUtil.isBlank(rule.getResource());
    }

    public static ManualDegradeRuleManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private class ManualDegradeRulePropertyListener
    extends SimplePropertyListener<List<ManualDegradeRule>> {
        private ManualDegradeRulePropertyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void configUpdate(List<ManualDegradeRule> list) {
            Map<String, ManualDegradeRule> newMap = this.buildNewMap(list);
            ManualDegradeRulePropertyListener manualDegradeRulePropertyListener = this;
            synchronized (manualDegradeRulePropertyListener) {
                ManualDegradeRuleManager.this.ruleMap = newMap;
                RecordLog.info("[ManualDegradeRuleManager] Rules has been updated to: " + newMap, new Object[0]);
            }
        }

        private Map<String, ManualDegradeRule> buildNewMap(List<ManualDegradeRule> list) {
            HashMap<String, ManualDegradeRule> map = new HashMap<String, ManualDegradeRule>(8);
            if (list == null || list.isEmpty()) {
                return map;
            }
            for (ManualDegradeRule rule : list) {
                if (!ManualDegradeRuleManager.isValidRule(rule)) {
                    RecordLog.warn("[ManualDegradeRuleManager] Ignoring invalid rule when loading new rules: " + rule, new Object[0]);
                    continue;
                }
                ManualDegradeRule prevRule = (ManualDegradeRule)map.get(rule.getResource());
                if (prevRule != null) {
                    RecordLog.info("[ManualDegradeRuleManager] Only one rule is needed for a single resource, so ignoring previous rule: " + prevRule, new Object[0]);
                }
                map.put(rule.getResource(), rule);
            }
            return map;
        }
    }

    private static class InstanceHolder {
        private static final ManualDegradeRuleManager INSTANCE = new ManualDegradeRuleManager();

        private InstanceHolder() {
        }
    }
}

