/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.Entry;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.context.Context;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.DefaultNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.AbstractLinkedProcessorSlot;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.spi.SpiOrder;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.List;

@SpiOrder(value=-1000)
public class DegradeSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        this.performChecking(resourceWrapper, context);
        this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
    }

    void performChecking(ResourceWrapper r, Context context) throws BlockException {
        List<CircuitBreaker> circuitBreakers = DegradeRuleManager.getCircuitBreakers(r.getName());
        if (circuitBreakers == null || circuitBreakers.isEmpty()) {
            return;
        }
        for (CircuitBreaker cb : circuitBreakers) {
            if (cb.tryPass(context)) continue;
            throw new DegradeException(cb.getRule().getLimitApp(), cb.getRule());
        }
    }

    @Override
    public void exit(Context context, ResourceWrapper r, int count, Object ... args) {
        Entry curEntry = context.getCurEntry();
        if (curEntry.getBlockError() != null) {
            this.fireExit(context, r, count, args);
            return;
        }
        List<CircuitBreaker> circuitBreakers = DegradeRuleManager.getCircuitBreakers(r.getName());
        if (circuitBreakers == null || circuitBreakers.isEmpty()) {
            this.fireExit(context, r, count, args);
            return;
        }
        if (curEntry.getBlockError() == null) {
            long completeTime = curEntry.getCompleteTimestamp();
            if (completeTime <= 0L) {
                completeTime = TimeUtil.currentTimeMillis();
            }
            long rt = completeTime - curEntry.getCreateTimestamp();
            Throwable error = curEntry.getError();
            for (CircuitBreaker circuitBreaker : circuitBreakers) {
                circuitBreaker.onRequestComplete(rt, error);
            }
        }
        this.fireExit(context, r, count, args);
    }
}

