/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.AbstractRule;

public class DegradeRule
extends AbstractRule {
    private int grade = 0;
    private double count;
    private int timeWindow;
    private int minRequestAmount = 5;
    private double slowRatioThreshold = 1.0;
    private int statIntervalMs = 1000;
    private int halfOpenBaseAmountPerStep = 5;
    private int halfOpenRecoveryStepNum = 1;

    public DegradeRule() {
    }

    public DegradeRule(String resourceName) {
        this.setResource(resourceName);
    }

    public int getGrade() {
        return this.grade;
    }

    public DegradeRule setGrade(int grade) {
        this.grade = grade;
        return this;
    }

    public double getCount() {
        return this.count;
    }

    public DegradeRule setCount(double count) {
        this.count = count;
        return this;
    }

    public int getTimeWindow() {
        return this.timeWindow;
    }

    public DegradeRule setTimeWindow(int timeWindow) {
        this.timeWindow = timeWindow;
        return this;
    }

    public int getMinRequestAmount() {
        return this.minRequestAmount;
    }

    public DegradeRule setMinRequestAmount(int minRequestAmount) {
        this.minRequestAmount = minRequestAmount;
        return this;
    }

    public double getSlowRatioThreshold() {
        return this.slowRatioThreshold;
    }

    public DegradeRule setSlowRatioThreshold(double slowRatioThreshold) {
        this.slowRatioThreshold = slowRatioThreshold;
        return this;
    }

    public int getStatIntervalMs() {
        return this.statIntervalMs;
    }

    public DegradeRule setStatIntervalMs(int statIntervalMs) {
        this.statIntervalMs = statIntervalMs;
        return this;
    }

    public int getHalfOpenBaseAmountPerStep() {
        return this.halfOpenBaseAmountPerStep;
    }

    public DegradeRule setHalfOpenBaseAmountPerStep(int halfOpenBaseAmountPerStep) {
        this.halfOpenBaseAmountPerStep = halfOpenBaseAmountPerStep;
        return this;
    }

    public int getHalfOpenRecoveryStepNum() {
        return this.halfOpenRecoveryStepNum;
    }

    public DegradeRule setHalfOpenRecoveryStepNum(int halfOpenRecoveryStepNum) {
        this.halfOpenRecoveryStepNum = halfOpenRecoveryStepNum;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DegradeRule that = (DegradeRule)o;
        if (this.grade != that.grade) {
            return false;
        }
        if (Double.compare(that.count, this.count) != 0) {
            return false;
        }
        if (this.timeWindow != that.timeWindow) {
            return false;
        }
        if (this.minRequestAmount != that.minRequestAmount) {
            return false;
        }
        if (Double.compare(that.slowRatioThreshold, this.slowRatioThreshold) != 0) {
            return false;
        }
        if (this.statIntervalMs != that.statIntervalMs) {
            return false;
        }
        if (this.halfOpenBaseAmountPerStep != that.halfOpenBaseAmountPerStep) {
            return false;
        }
        return this.halfOpenRecoveryStepNum == that.halfOpenRecoveryStepNum;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.grade;
        long temp = Double.doubleToLongBits(this.count);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.timeWindow;
        result = 31 * result + this.minRequestAmount;
        temp = Double.doubleToLongBits(this.slowRatioThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.statIntervalMs;
        result = 31 * result + this.halfOpenBaseAmountPerStep;
        result = 31 * result + this.halfOpenRecoveryStepNum;
        return result;
    }

    public String toString() {
        return "DegradeRule{resource=" + this.getResource() + ", grade=" + this.grade + ", count=" + this.count + ", limitApp=" + this.getLimitApp() + ", timeWindow=" + this.timeWindow + ", minRequestAmount=" + this.minRequestAmount + ", slowRatioThreshold=" + this.slowRatioThreshold + ", statIntervalMs=" + this.statIntervalMs + ", halfOpenBaseAmountPerStep=" + this.halfOpenBaseAmountPerStep + ", halfOpenRecoveryStepNum=" + this.halfOpenRecoveryStepNum + '}';
    }
}

