/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.Entry;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.EntryType;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.context.Context;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.DefaultNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.AbstractLinkedProcessorSlot;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.DefaultCircuitBreakerRuleManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.TimeUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.whitelist.WhiteListConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.whitelist.WhiteListConfigManager;
import java.util.List;

public class DefaultCircuitBreakerSlot
extends AbstractLinkedProcessorSlot<DefaultNode> {
    @Override
    public void entry(Context context, ResourceWrapper resourceWrapper, DefaultNode node, int count, boolean prioritized, Object ... args) throws Throwable {
        this.performChecking(context, resourceWrapper);
        this.fireEntry(context, resourceWrapper, node, count, prioritized, args);
    }

    private void performChecking(Context context, ResourceWrapper r) throws BlockException {
        if (r == null || r.getEntryType() != EntryType.OUT) {
            return;
        }
        if (DegradeRuleManager.hasConfig(r.getName())) {
            return;
        }
        List<CircuitBreaker> circuitBreakers = DefaultCircuitBreakerRuleManager.getDefaultCircuitBreakers(r.getName());
        if (circuitBreakers == null || circuitBreakers.isEmpty()) {
            return;
        }
        for (CircuitBreaker cb : circuitBreakers) {
            if (!this.shouldCheck(r, cb)) {
                return;
            }
            if (cb.tryPass(context)) continue;
            if (cb.getRule().getGrade() == 0) {
                throw new DegradeException("rt", cb.getRule());
            }
            if (cb.getRule().getGrade() != 1) continue;
            throw new DegradeException("exception", cb.getRule());
        }
    }

    @Override
    public void exit(Context context, ResourceWrapper r, int count, Object ... args) {
        Entry curEntry = context.getCurEntry();
        if (curEntry.getBlockError() != null) {
            this.fireExit(context, r, count, args);
            return;
        }
        if (DegradeRuleManager.hasConfig(r.getName())) {
            this.fireExit(context, r, count, args);
            return;
        }
        List<CircuitBreaker> circuitBreakers = DefaultCircuitBreakerRuleManager.getDefaultCircuitBreakers(r.getName());
        if (circuitBreakers == null || circuitBreakers.isEmpty()) {
            this.fireExit(context, r, count, args);
            return;
        }
        if (curEntry.getBlockError() == null) {
            long completeTime = curEntry.getCompleteTimestamp();
            if (completeTime <= 0L) {
                completeTime = TimeUtil.currentTimeMillis();
            }
            long rt = completeTime - curEntry.getCreateTimestamp();
            Throwable error = curEntry.getError();
            for (CircuitBreaker circuitBreaker : circuitBreakers) {
                circuitBreaker.onRequestComplete(rt, error);
            }
        }
        this.fireExit(context, r, count, args);
    }

    private boolean shouldCheck(ResourceWrapper r, CircuitBreaker circuitBreakers) {
        WhiteListConfig whiteListConfig;
        String resourceName = r.getName();
        switch (circuitBreakers.getRule().getGrade()) {
            case 0: {
                whiteListConfig = WhiteListConfigManager.getWhiteList("default_circuit_breaker_rt");
                break;
            }
            case 1: {
                whiteListConfig = WhiteListConfigManager.getWhiteList("default_circuit_breaker_exception");
                break;
            }
            default: {
                return true;
            }
        }
        if (whiteListConfig == null) {
            return true;
        }
        return !whiteListConfig.getWhiteList().contains(resourceName);
    }
}

