/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.PropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.CircuitBreaker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.ExceptionRatioCircuitBreaker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.circuitbreaker.ResponseTimeCircuitBreaker;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.CollectionUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultCircuitBreakerRuleManager {
    public static final String DEFAULT_KEY = "*";
    private static volatile Map<String, List<CircuitBreaker>> circuitBreakers = new ConcurrentHashMap<String, List<CircuitBreaker>>();
    private static volatile Set<DegradeRule> rules = new HashSet<DegradeRule>();
    private static final Set<String> excludedResource = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final RulePropertyListener LISTENER = new RulePropertyListener();
    private static SentinelProperty<List<DegradeRule>> currentProperty = new DynamicSentinelProperty<List<DegradeRule>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<List<DegradeRule>> property) {
        AssertUtil.notNull(property, "property cannot be null");
        RulePropertyListener rulePropertyListener = LISTENER;
        synchronized (rulePropertyListener) {
            RecordLog.info("[DefaultDegradeRuleManager] Registering new property to default degrade rule manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    static List<CircuitBreaker> getDefaultCircuitBreakers(String resourceName) {
        if (CollectionUtil.isEmpty(rules)) {
            return null;
        }
        List<CircuitBreaker> circuitBreakers = DefaultCircuitBreakerRuleManager.circuitBreakers.get(resourceName);
        if (circuitBreakers == null && !rules.isEmpty() && !excludedResource.contains(resourceName)) {
            circuitBreakers = new ArrayList<CircuitBreaker>();
            for (DegradeRule rule : rules) {
                circuitBreakers.add(DefaultCircuitBreakerRuleManager.newCircuitBreakerFrom(rule));
            }
            DefaultCircuitBreakerRuleManager.circuitBreakers.put(resourceName, circuitBreakers);
            return circuitBreakers;
        }
        return circuitBreakers;
    }

    public static void addExcludedResource(String resourceName) {
        if (resourceName == null) {
            return;
        }
        excludedResource.add(resourceName);
    }

    public static void removeExcludedResource(String resourceName) {
        if (resourceName == null) {
            return;
        }
        excludedResource.remove(resourceName);
    }

    public static void clearExcludedResource() {
        excludedResource.clear();
    }

    public static boolean loadRules(List<DegradeRule> rules) {
        try {
            return currentProperty.updateValue(rules);
        }
        catch (Throwable e) {
            RecordLog.error("[DefaultCircuitBreakerRuleManager] Unexpected error when loading default rules", e);
            return false;
        }
    }

    public static boolean isValidDefaultRule(DegradeRule rule) {
        if (!DegradeRuleManager.isValidRule(rule)) {
            return false;
        }
        return rule.getResource().equals(DEFAULT_KEY);
    }

    private static CircuitBreaker newCircuitBreakerFrom(DegradeRule rule) {
        switch (rule.getGrade()) {
            case 0: {
                return new ResponseTimeCircuitBreaker(rule);
            }
            case 1: 
            case 2: {
                return new ExceptionRatioCircuitBreaker(rule);
            }
        }
        return null;
    }

    private static CircuitBreaker getExistingSameCbOrNew(DegradeRule rule) {
        List<CircuitBreaker> cbs = DefaultCircuitBreakerRuleManager.getCircuitBreakers(rule.getResource());
        if (cbs == null || cbs.isEmpty()) {
            return DefaultCircuitBreakerRuleManager.newCircuitBreakerFrom(rule);
        }
        for (CircuitBreaker cb : cbs) {
            if (!rule.equals(cb.getRule())) continue;
            return cb;
        }
        return DefaultCircuitBreakerRuleManager.newCircuitBreakerFrom(rule);
    }

    static List<CircuitBreaker> getCircuitBreakers(String resourceName) {
        return circuitBreakers.get(resourceName);
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    private static class RulePropertyListener
    implements PropertyListener<List<DegradeRule>> {
        private RulePropertyListener() {
        }

        private synchronized void reloadFrom(List<DegradeRule> list) {
            if (list == null || list.isEmpty()) {
                circuitBreakers = new ConcurrentHashMap();
                rules = new HashSet();
                return;
            }
            HashSet<DegradeRule> rules = new HashSet<DegradeRule>();
            for (DegradeRule rule : list) {
                if (!DefaultCircuitBreakerRuleManager.isValidDefaultRule(rule)) {
                    RecordLog.warn("[DefaultCircuitBreakerRuleManager] Ignoring invalid rule when loading new rules: {}", rule);
                    continue;
                }
                if (StringUtil.isBlank(rule.getLimitApp())) {
                    rule.setLimitApp("default");
                }
                rule.setId(0L);
                rules.add(rule);
            }
            ConcurrentHashMap cbMap = new ConcurrentHashMap(8);
            for (String resourceNameKey : circuitBreakers.keySet()) {
                ArrayList<CircuitBreaker> cbs = new ArrayList<CircuitBreaker>();
                for (DegradeRule rule : rules) {
                    CircuitBreaker cb = DefaultCircuitBreakerRuleManager.getExistingSameCbOrNew(rule);
                    cbs.add(cb);
                }
                cbMap.put(resourceNameKey, cbs);
            }
            rules = rules;
            circuitBreakers = cbMap;
        }

        @Override
        public void configUpdate(List<DegradeRule> conf) {
            this.reloadFrom(conf);
            RecordLog.info("[DefaultCircuitBreakerRuleManager] Default circuit breaker rules has been updated to: {}", rules);
        }

        @Override
        public void configLoad(List<DegradeRule> conf) {
            this.reloadFrom(conf);
            RecordLog.info("[DefaultCircuitBreakerRuleManager] Default circuit breaker rules loaded: {}", rules);
        }
    }
}

