/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricWriter;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricsReader;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.TrafficExceptionStatistics;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.TimeUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TrafficExceptionStatisticsManager {
    private static volatile TrafficExceptionStatisticsManager trafficExceptionStatisticsManager;
    private static final long FIVE_MINUTES = 300000L;
    private static final long FIVE_SECONDS = 5000L;
    private static final String BLOCK_FILE = "blocks_statistics.log";
    private final MetricWriter metricWriter = new MetricWriter(SentinelConfig.singleMetricFileSize(), SentinelConfig.totalMetricFileCount());
    private final MetricsReader trafficBlockReader = new MetricsReader(Charset.forName(SentinelConfig.charset()));
    private static final int KEEP_ALIVE_TIME = 120000;
    private static final int QUEUE_SIZE = 40960;
    private final ExecutorService fetchService;
    private final ScheduledExecutorService scheduler;
    TimerTask writeTask = new TimerTask(){

        @Override
        public void run() {
            try {
                TrafficExceptionStatisticsManager.this.trafficBlockReader.commonRemove(TrafficExceptionStatisticsManager.BLOCK_FILE);
            }
            catch (Exception ex) {
                RecordLog.warn("[ONE_TRAFFIC_BLOCKS] failed to clean one metrics with error ", ex);
            }
            try {
                Map<String, Integer> blockExceptionMetrics = TrafficExceptionStatistics.getInstance().takeBlockExceptions();
                ArrayList<String> blocks = new ArrayList<String>();
                long time = TimeUtil.currentTimeMillis();
                long finalTime = time - time % 1000L;
                for (String key : blockExceptionMetrics.keySet()) {
                    Integer num = blockExceptionMetrics.get(key);
                    if (num == null) continue;
                    blocks.add(key + "|" + finalTime + "|" + num);
                }
                TrafficExceptionStatisticsManager.this.metricWriter.commonWrite(blocks, TrafficExceptionStatisticsManager.BLOCK_FILE);
            }
            catch (Exception e) {
                RecordLog.warn("Failed to write BLOCK metrics on disk", e);
            }
        }
    };

    private TrafficExceptionStatisticsManager() {
        this.fetchService = new ThreadPoolExecutor(1, 1, 120000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(40960), new NamedThreadFactory("sentinel-traffic-block-record-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
        int coreNum = Runtime.getRuntime().availableProcessors();
        this.scheduler = Executors.newScheduledThreadPool(coreNum, new NamedThreadFactory("sentinel-traffic-block-write-task", true));
        this.scheduler.scheduleWithFixedDelay(this.writeTask, 5000L, 300000L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TrafficExceptionStatisticsManager getInstance() {
        if (trafficExceptionStatisticsManager != null) return trafficExceptionStatisticsManager;
        Class<TrafficExceptionStatisticsManager> clazz = TrafficExceptionStatisticsManager.class;
        synchronized (TrafficExceptionStatisticsManager.class) {
            if (trafficExceptionStatisticsManager != null) return trafficExceptionStatisticsManager;
            trafficExceptionStatisticsManager = new TrafficExceptionStatisticsManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return trafficExceptionStatisticsManager;
        }
    }

    public boolean recordBlockExceptions(final String resource, final int resourceType, final BlockException blockException) {
        try {
            this.fetchService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        TrafficExceptionStatistics.getInstance().statisticBlockException(resource, resourceType, blockException);
                    }
                    catch (Throwable e) {
                        RecordLog.warn("[BLOCK-EXCEPTION-RECORD] failed, {}, {}, {}", resource, blockException, e);
                    }
                }
            });
            return true;
        }
        catch (Exception ex) {
            RecordLog.error("Failed to recordStatusCode for resource {}", resource, ex);
            return false;
        }
    }
}

