/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.flow.FlowException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.isolation.ConcurrencyLimitException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TrafficExceptionStatistics {
    private static volatile TrafficExceptionStatistics trafficExceptionStatistics;
    private Map<String, Integer> blockExceptionMetrics = new ConcurrentHashMap<String, Integer>();
    private Map<String, String> blockException2Rule = new HashMap<String, String>(){
        {
            this.put(DegradeException.class.getSimpleName(), "DegradeRule");
            this.put(FlowException.class.getSimpleName(), "FlowRule");
            this.put(ConcurrencyLimitException.class.getSimpleName(), "IsolationRule");
            this.put("ParamFlowException", "ParamFlowRule");
            this.put("ServiceDegradedException", "ManualDegradeRule");
            this.put("SystemBlockException", "SystemRule");
            this.put("WebFlowException", "WebFlowRule");
        }
    };

    private TrafficExceptionStatistics() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TrafficExceptionStatistics getInstance() {
        if (trafficExceptionStatistics != null) return trafficExceptionStatistics;
        Class<TrafficExceptionStatistics> clazz = TrafficExceptionStatistics.class;
        synchronized (TrafficExceptionStatistics.class) {
            if (trafficExceptionStatistics != null) return trafficExceptionStatistics;
            trafficExceptionStatistics = new TrafficExceptionStatistics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return trafficExceptionStatistics;
        }
    }

    public void statisticBlockException(String resource, int resourceType, BlockException blockException) {
        String ruleInfo = resource + "|" + resourceType + "|" + blockException.getRule().getId() + "|" + this.blockException2Rule.get(blockException.getClass().getSimpleName()) + "|" + blockException.getRuleLimitApp();
        Integer oriNum = this.blockExceptionMetrics.get(ruleInfo);
        if (oriNum == null) {
            this.blockExceptionMetrics.put(ruleInfo, 1);
        } else {
            this.blockExceptionMetrics.replace(ruleInfo, oriNum + 1);
        }
    }

    public Map<String, Integer> takeBlockExceptions() {
        Map<String, Integer> copy = this.blockExceptionMetrics;
        this.blockExceptionMetrics = new ConcurrentHashMap<String, Integer>();
        return copy;
    }
}

