/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.EntryType;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;

public abstract class ResourceWrapper {
    protected final String name;
    protected final EntryType entryType;
    protected final int resourceType;

    public ResourceWrapper(String name, EntryType entryType, int resourceType) {
        AssertUtil.assertNotBlank(name, "resource name cannot be empty");
        AssertUtil.notNull((Object)entryType, "entryType cannot be null");
        if (name.length() > 1024) {
            name = name.substring(0, 1024);
        }
        this.name = name;
        this.entryType = entryType;
        this.resourceType = resourceType;
    }

    public String getName() {
        return this.name;
    }

    public EntryType getEntryType() {
        return this.entryType;
    }

    public int getResourceType() {
        return this.resourceType;
    }

    public abstract String getShowName();

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResourceWrapper) {
            ResourceWrapper rw = (ResourceWrapper)obj;
            return rw.getName().equals(this.getName());
        }
        return false;
    }
}

