/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.fallback;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.GenericTypeUtils;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfigManager;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.system.SystemBlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.BiFunction;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Tuple2;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;

public final class BlockFallbackUtils {
    private static ClassLoader appContextClassLoader;
    private static BiFunction<String, Type, Object> parseObjectFunction;

    public static void setAppContextClassLoader(ClassLoader appContextClassLoader) {
        BlockFallbackUtils.appContextClassLoader = appContextClassLoader;
    }

    public static void setParseObjectFunction(BiFunction<String, Type, Object> function) {
        parseObjectFunction = function;
    }

    public static BlockFallbackConfig.WebBlockFallbackBehavior getFallbackBehavior(String resource, BlockException ex) {
        if (ex == null) {
            return null;
        }
        BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior> c = ex instanceof SystemBlockException ? BlockFallbackConfigManager.getInstance().getWebFallbackConfig("__system_block_exception_resource__", ex.getClass()) : BlockFallbackConfigManager.getInstance().getWebFallbackConfig(resource, ex.getClass());
        if (c == null) {
            return null;
        }
        return c.getFallbackBehavior();
    }

    public static BlockFallbackConfig.RpcBlockFallbackBehavior getRpcFallbackBehavior(String resource, BlockException ex) {
        if (ex == null) {
            return null;
        }
        BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior> c = ex instanceof SystemBlockException ? BlockFallbackConfigManager.getInstance().getRpcFallbackConfig("__system_block_exception_resource__", ex.getClass()) : BlockFallbackConfigManager.getInstance().getRpcFallbackConfig(resource, ex.getClass());
        if (c == null) {
            return null;
        }
        return c.getFallbackBehavior();
    }

    public static Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior> getRpcFallbackInstance(String resource, BlockException ex) throws Exception {
        if (ex == null) {
            return null;
        }
        if (ex instanceof SystemBlockException) {
            return BlockFallbackConfigManager.getInstance().getRpcFallbackObjectInstance("__system_block_exception_resource__", ex.getClass());
        }
        return BlockFallbackConfigManager.getInstance().getRpcFallbackObjectInstance(resource, ex.getClass());
    }

    public static Object resolveRpcFallbackObjectInstance(BlockFallbackConfig.RpcBlockFallbackBehavior b) throws Exception {
        AssertUtil.assertNotNull(b, "rpcBlockFallbackBehavior cannot be null");
        AssertUtil.assertNotNull(b.getRpcFallbackMode(), "rpcFallbackMode cannot be null");
        int fallbackMode = b.getRpcFallbackMode();
        if (fallbackMode == 0) {
            Type returnType = GenericTypeUtils.genericReturnType(b.getRpcRespFallbackClassName(), appContextClassLoader);
            if (parseObjectFunction != null) {
                return parseObjectFunction.apply(b.getRpcRespContentBody(), returnType);
            }
            return JSON.parseObject((String)b.getRpcRespContentBody(), (Type)returnType, (Feature[])new Feature[0]);
        }
        if (fallbackMode == 1) {
            Class<?> clazz = appContextClassLoader != null ? Class.forName(b.getRpcRespFallbackClassName(), true, appContextClassLoader) : Class.forName(b.getRpcRespFallbackClassName());
            if (Throwable.class.isAssignableFrom(clazz)) {
                Constructor<?> con = clazz.getConstructor(String.class);
                return con.newInstance(b.getRpcFallbackExceptionMessage());
            }
            throw new IllegalArgumentException("Fallback object type is not a subtype of Throwable: " + clazz.getName());
        }
        return null;
    }

    public static boolean checkRpcFallbackInstance(BlockFallbackConfig.RpcBlockFallbackBehavior behavior) {
        try {
            BlockFallbackUtils.resolveRpcFallbackObjectInstance(behavior);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private BlockFallbackUtils() {
    }
}

