/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.fallback;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SimplePropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConstants;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.fallback.BlockFallbackUtils;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.CollectionUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.ObjectUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Tuple2;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class BlockFallbackConfigManager {
    private volatile Map<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior>>> webFallbackConfigMap = new HashMap<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior>>>();
    private volatile Map<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior>>> rpcFallbackConfigMap = new HashMap<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior>>>();
    private Map<String, Map<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>>> rpcFallbackInstanceMap = new ConcurrentHashMap<String, Map<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>>>();
    private SentinelProperty<List<BlockFallbackConfig<Object>>> currentProperty = new DynamicSentinelProperty<List<BlockFallbackConfig<Object>>>();
    private final BlockFallbackConfigPropertyListener propertyListener = new BlockFallbackConfigPropertyListener();

    protected BlockFallbackConfigManager() {
        this.currentProperty.addListener(this.propertyListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register2Property(SentinelProperty<List<BlockFallbackConfig<Object>>> property) {
        AssertUtil.notNull(property, "property cannot be null");
        BlockFallbackConfigPropertyListener blockFallbackConfigPropertyListener = this.propertyListener;
        synchronized (blockFallbackConfigPropertyListener) {
            RecordLog.info("[BlockFallbackConfigManager] Registering new property to BlockFallbackConfig manager", new Object[0]);
            this.currentProperty.removeListener(this.propertyListener);
            property.addListener(this.propertyListener);
            this.currentProperty = property;
        }
    }

    public boolean loadConfig(List<BlockFallbackConfig<Object>> configList) {
        return this.currentProperty.updateValue(configList);
    }

    public BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior> getWebFallbackConfig(String resource, Class<?> exceptionClazz) {
        if (resource == null || exceptionClazz == null) {
            return null;
        }
        Map<Integer, BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior>> m = this.webFallbackConfigMap.get(resource);
        if (CollectionUtil.isEmpty(m)) {
            return null;
        }
        Integer blockType = BlockFallbackConstants.parseBlockType(exceptionClazz);
        if (blockType == null) {
            return m.get(0);
        }
        BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior> c = m.get(blockType);
        if (c == null) {
            c = m.get(0);
        }
        return c;
    }

    public BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior> getRpcFallbackConfig(String resource, Class<?> exceptionClazz) {
        if (resource == null || exceptionClazz == null) {
            return null;
        }
        Map<Integer, BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior>> m = this.rpcFallbackConfigMap.get(resource);
        if (CollectionUtil.isEmpty(m)) {
            return null;
        }
        Integer blockType = BlockFallbackConstants.parseBlockType(exceptionClazz);
        if (blockType == null) {
            return m.get(0);
        }
        BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior> c = m.get(blockType);
        if (c == null) {
            c = m.get(0);
        }
        return c;
    }

    public Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior> getCachedRpcFallbackInstance(String resource, Class<?> exceptionClazz) {
        if (resource == null || exceptionClazz == null) {
            return null;
        }
        Map<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>> m = this.rpcFallbackInstanceMap.get(resource);
        if (CollectionUtil.isEmpty(m)) {
            return null;
        }
        Integer blockType = BlockFallbackConstants.parseBlockType(exceptionClazz);
        if (blockType == null) {
            return m.get(0);
        }
        Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior> c = m.get(blockType);
        if (c == null) {
            c = m.get(0);
        }
        return c;
    }

    public Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior> getRpcFallbackObjectInstance(String resource, Class<?> exceptionClazz) throws Exception {
        BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior> c = this.getRpcFallbackConfig(resource, exceptionClazz);
        if (c == null) {
            return null;
        }
        BlockFallbackConfig.RpcBlockFallbackBehavior b = c.getFallbackBehavior();
        if (b.getRpcFallbackCacheMode().equals(1)) {
            return this.getCachedRpcFallbackInstance(resource, exceptionClazz);
        }
        return Tuple2.of(BlockFallbackUtils.resolveRpcFallbackObjectInstance(b), b);
    }

    public static boolean isValidConfig(BlockFallbackConfig config) {
        if (config == null || config.getFallbackBehavior() == null) {
            return false;
        }
        Integer targetResourceType = config.getTargetResourceType();
        if (targetResourceType == null) {
            return false;
        }
        if (!BlockFallbackConstants.isResourceTypeSupportedAndMatch(targetResourceType, config.getFallbackBehavior())) {
            return false;
        }
        if (CollectionUtil.isEmpty(config.getTargetMap())) {
            return false;
        }
        if (targetResourceType == 1) {
            return BlockFallbackConfigManager.isValidWebBlockFallbackBehavior((BlockFallbackConfig.WebBlockFallbackBehavior)config.getFallbackBehavior());
        }
        if (targetResourceType == 2) {
            return BlockFallbackConfigManager.isValidRpcBlockFallbackBehavior((BlockFallbackConfig.RpcBlockFallbackBehavior)config.getFallbackBehavior());
        }
        return true;
    }

    public static boolean isValidWebBlockFallbackBehavior(BlockFallbackConfig.WebBlockFallbackBehavior b) {
        if (b.getWebFallbackMode() == null || b.getWebFallbackMode() < 0) {
            return false;
        }
        if (b.getWebFallbackMode() == 0) {
            if (b.getWebRespContentType() == null || b.getWebRespContentType() < 0) {
                return false;
            }
            if (StringUtil.isEmpty(b.getWebRespMessage())) {
                return false;
            }
            Integer blockStatus = b.getWebRespStatusCode();
            return blockStatus != null && blockStatus > 0 && blockStatus <= 999;
        }
        if (b.getWebFallbackMode() == 1) {
            return StringUtil.isNotBlank(b.getWebRedirectUrl());
        }
        return false;
    }

    public static boolean isValidRpcBlockFallbackBehavior(BlockFallbackConfig.RpcBlockFallbackBehavior b) {
        if (b.getRpcFallbackMode() == null || b.getRpcFallbackMode() < 0) {
            return false;
        }
        if (StringUtil.isBlank(b.getRpcRespFallbackClassName())) {
            return false;
        }
        if (b.getRpcFallbackCacheMode() == null) {
            return false;
        }
        if (b.getRpcFallbackMode() == 0) {
            if (StringUtil.isBlank(b.getRpcRespContentBody())) {
                return false;
            }
        } else if (b.getRpcFallbackMode() == 1) {
            if (StringUtil.isEmpty(b.getRpcFallbackExceptionMessage())) {
                return false;
            }
        } else {
            return false;
        }
        return BlockFallbackUtils.checkRpcFallbackInstance(b);
    }

    public Map<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>> updateRpcFallbackCachedInstance(String resourceName, Set<Integer> resourceClassificationSet, BlockFallbackConfig.RpcBlockFallbackBehavior rpcBlockFallbackBehavior) {
        Map<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>> behaviorMap = this.rpcFallbackInstanceMap.get(resourceName);
        if (behaviorMap == null) {
            behaviorMap = new HashMap<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>>();
            for (Integer integer : resourceClassificationSet) {
                try {
                    behaviorMap.put(integer, new Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>(BlockFallbackUtils.resolveRpcFallbackObjectInstance(rpcBlockFallbackBehavior), rpcBlockFallbackBehavior));
                }
                catch (Exception e) {
                    RecordLog.warn("[BlockFallbackConfigManager] Try to init rpc fallback behavior object error", e);
                }
            }
        } else {
            for (Integer integer : resourceClassificationSet) {
                if (ObjectUtil.equals(rpcBlockFallbackBehavior, behaviorMap.get((Object)integer).r2)) continue;
                try {
                    behaviorMap.put(integer, new Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>(BlockFallbackUtils.resolveRpcFallbackObjectInstance(rpcBlockFallbackBehavior), rpcBlockFallbackBehavior));
                }
                catch (Exception e) {
                    RecordLog.warn("[BlockFallbackConfigManager] Update rpc fallback instance error", e);
                }
            }
        }
        return this.rpcFallbackInstanceMap.put(resourceName, behaviorMap);
    }

    Map<String, Map<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>>> getRpcFallbackInstanceMap() {
        return this.rpcFallbackInstanceMap;
    }

    public static BlockFallbackConfigManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private class BlockFallbackConfigPropertyListener
    extends SimplePropertyListener<List<BlockFallbackConfig<Object>>> {
        private BlockFallbackConfigPropertyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void configUpdate(List<BlockFallbackConfig<Object>> list) {
            Map<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior>>> newWebFallbackMap = this.buildWebFallbackMapFrom(list);
            Map<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior>>> newRpcFallbackMap = this.buildRpcFallbackMapFrom(list);
            Map<String, Map<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>>> newRpcInstanceMap = this.buildRpcFallbackInstanceMap(list);
            BlockFallbackConfigPropertyListener blockFallbackConfigPropertyListener = this;
            synchronized (blockFallbackConfigPropertyListener) {
                BlockFallbackConfigManager.this.webFallbackConfigMap = newWebFallbackMap;
                RecordLog.info("[BlockFallbackConfigManager] Web fallback config has been updated to: " + newWebFallbackMap, new Object[0]);
                BlockFallbackConfigManager.this.rpcFallbackConfigMap = newRpcFallbackMap;
                RecordLog.info("[BlockFallbackConfigManager] RPC fallback config has been updated to: " + newRpcFallbackMap, new Object[0]);
                BlockFallbackConfigManager.this.rpcFallbackInstanceMap = newRpcInstanceMap;
                RecordLog.info("[BlockFallbackConfigManager] RPC instance has been updated to: " + newRpcFallbackMap, new Object[0]);
            }
        }

        private Map<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior>>> buildWebFallbackMapFrom(List<BlockFallbackConfig<Object>> list) {
            HashMap<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior>>> map = new HashMap<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.WebBlockFallbackBehavior>>>(8);
            if (list == null || list.isEmpty()) {
                return map;
            }
            for (BlockFallbackConfig<Object> config : list) {
                if (!BlockFallbackConfigManager.isValidConfig(config)) {
                    RecordLog.warn("[BlockFallbackConfigManager] Ignoring invalid config when loading new configs: " + config, new Object[0]);
                    continue;
                }
                if (!config.getTargetResourceType().equals(1)) continue;
                for (Map.Entry<String, Set<Integer>> e : config.getTargetMap().entrySet()) {
                    HashMap<Integer, BlockFallbackConfig<Object>> mm = (HashMap<Integer, BlockFallbackConfig<Object>>)map.get(e.getKey());
                    if (mm == null) {
                        mm = new HashMap<Integer, BlockFallbackConfig<Object>>();
                        map.put(e.getKey(), mm);
                    }
                    for (Integer t : e.getValue()) {
                        mm.put(t, config);
                    }
                }
            }
            return map;
        }

        private Map<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior>>> buildRpcFallbackMapFrom(List<BlockFallbackConfig<Object>> list) {
            HashMap<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior>>> map = new HashMap<String, Map<Integer, BlockFallbackConfig<BlockFallbackConfig.RpcBlockFallbackBehavior>>>(8);
            if (list == null || list.isEmpty()) {
                return map;
            }
            for (BlockFallbackConfig<Object> config : list) {
                if (!BlockFallbackConfigManager.isValidConfig(config)) {
                    RecordLog.warn("[BlockFallbackConfigManager] Ignoring invalid config when loading new configs: " + config, new Object[0]);
                    continue;
                }
                if (!config.getTargetResourceType().equals(2)) continue;
                for (Map.Entry<String, Set<Integer>> e : config.getTargetMap().entrySet()) {
                    HashMap<Integer, BlockFallbackConfig<Object>> mm = (HashMap<Integer, BlockFallbackConfig<Object>>)map.get(e.getKey());
                    if (mm == null) {
                        mm = new HashMap<Integer, BlockFallbackConfig<Object>>();
                        map.put(e.getKey(), mm);
                    }
                    for (Integer t : e.getValue()) {
                        mm.put(t, config);
                    }
                }
            }
            return map;
        }

        private Map<String, Map<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>>> buildRpcFallbackInstanceMap(List<BlockFallbackConfig<Object>> list) {
            HashMap<String, Map<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>>> map = new HashMap<String, Map<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>>>(8);
            if (list == null || list.isEmpty()) {
                return map;
            }
            for (BlockFallbackConfig<Object> config : list) {
                BlockFallbackConfig.RpcBlockFallbackBehavior rpcBlockFallbackBehavior;
                if (!BlockFallbackConfigManager.isValidConfig(config)) {
                    RecordLog.warn("[BlockFallbackConfigManager] Ignoring invalid config when loading new configs: " + config, new Object[0]);
                    continue;
                }
                if (!config.getTargetResourceType().equals(2) || (rpcBlockFallbackBehavior = (BlockFallbackConfig.RpcBlockFallbackBehavior)config.getFallbackBehavior()).getRpcFallbackCacheMode() != 1) continue;
                for (Map.Entry<String, Set<Integer>> entry : config.getTargetMap().entrySet()) {
                    HashMap<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>> behaviorMap = (HashMap<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>>)map.get(entry.getKey());
                    if (behaviorMap == null) {
                        behaviorMap = new HashMap<Integer, Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>>();
                        map.put(entry.getKey(), behaviorMap);
                    }
                    for (Integer integer : entry.getValue()) {
                        try {
                            behaviorMap.put(integer, new Tuple2<Object, BlockFallbackConfig.RpcBlockFallbackBehavior>(BlockFallbackUtils.resolveRpcFallbackObjectInstance(rpcBlockFallbackBehavior), rpcBlockFallbackBehavior));
                        }
                        catch (Exception ex) {
                            RecordLog.warn("[BlockFallbackConfigManager] Update rpc fallback instance error", ex);
                        }
                    }
                }
            }
            return map;
        }
    }

    private static class InstanceHolder {
        private static final BlockFallbackConfigManager INSTANCE = new BlockFallbackConfigManager();

        private InstanceHolder() {
        }
    }
}

