/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.adapter;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SimplePropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.adapter.SentinelAdapterSettingEntity;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting.fallback.BlockFallbackConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Consumer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class AdapterSettingManager {
    private static volatile SentinelAdapterSettingEntity currentSetting = null;
    private static volatile BlockFallbackConfig.WebBlockFallbackBehavior currentGlobalWebBehavior = null;
    private static final AdapterSettingPropertyListener LISTENER = new AdapterSettingPropertyListener();
    private static SentinelProperty<SentinelAdapterSettingEntity> currentProperty = new DynamicSentinelProperty<SentinelAdapterSettingEntity>();
    private static final List<Consumer<SentinelAdapterSettingEntity>> OBSERVERS = new CopyOnWriteArrayList<Consumer<SentinelAdapterSettingEntity>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<SentinelAdapterSettingEntity> property) {
        AssertUtil.notNull(property, "property cannot be null");
        AdapterSettingPropertyListener adapterSettingPropertyListener = LISTENER;
        synchronized (adapterSettingPropertyListener) {
            RecordLog.info("[AdapterSettingManager] Registering new property to adapter setting manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            property.addListener(LISTENER);
            currentProperty = property;
        }
    }

    public static SentinelAdapterSettingEntity getCurrentAdapterSetting() {
        return currentSetting;
    }

    public static boolean isValidProperties(SentinelAdapterSettingEntity properties) {
        if (properties == null || properties.getWebFallbackMode() == null) {
            return false;
        }
        if (properties.getWebFallbackMode() == 1 && StringUtil.isNotBlank(properties.getWebRedirectUrl())) {
            return true;
        }
        Integer blockStatus = properties.getWebRespStatusCode();
        if (properties.getWebFallbackMode() == 0 && blockStatus != null) {
            return blockStatus > 0 && blockStatus <= 999;
        }
        return false;
    }

    public static void addObserver(Consumer<SentinelAdapterSettingEntity> observer) {
        AssertUtil.notNull(observer, "observer cannot be empty");
        OBSERVERS.add(observer);
    }

    public static boolean removeObserver(Consumer<SentinelAdapterSettingEntity> observer) {
        AssertUtil.notNull(observer, "observer cannot be empty");
        return OBSERVERS.remove(observer);
    }

    private static BlockFallbackConfig.WebBlockFallbackBehavior settingToWebFallbackBehavior(SentinelAdapterSettingEntity setting) {
        if (setting == null) {
            return null;
        }
        return new BlockFallbackConfig.WebBlockFallbackBehavior().setWebFallbackMode(setting.getWebFallbackMode()).setWebRedirectUrl(setting.getWebRedirectUrl()).setWebRespContentType(setting.getWebRespContentType()).setWebRespMessage(setting.getWebRespMessage()).setWebRespStatusCode(setting.getWebRespStatusCode());
    }

    public static BlockFallbackConfig.WebBlockFallbackBehavior getCurrentGlobalWebBehavior() {
        return currentGlobalWebBehavior;
    }

    public static Integer getWebRespStatusCode() {
        return currentSetting == null ? null : currentSetting.getWebRespStatusCode();
    }

    public static String getWebRespMessage() {
        return currentSetting == null ? null : currentSetting.getWebRespMessage();
    }

    public static Integer getWebRespContentType() {
        return currentSetting == null ? null : currentSetting.getWebRespContentType();
    }

    private AdapterSettingManager() {
    }

    static {
        currentProperty.addListener(LISTENER);
    }

    private static class AdapterSettingPropertyListener
    extends SimplePropertyListener<SentinelAdapterSettingEntity> {
        private AdapterSettingPropertyListener() {
        }

        @Override
        public synchronized void configUpdate(SentinelAdapterSettingEntity properties) {
            if (properties == null) {
                return;
            }
            if (!AdapterSettingManager.isValidProperties(properties)) {
                RecordLog.warn("[AdapterSettingManager] Ignoring invalid setting: " + properties, new Object[0]);
                return;
            }
            switch (properties.getWebFallbackMode()) {
                case 1: {
                    String redirectUrl = properties.getWebRedirectUrl();
                    if (redirectUrl.equals(SentinelConfig.getConfig("io.opentelemetry.javaagent.mse.shaded.csp.sentinel.web.servlet.block.page"))) break;
                    RecordLog.info("[AdapterSettingManager] Setting web block redirect URL to " + redirectUrl, new Object[0]);
                    SentinelConfig.setConfig("io.opentelemetry.javaagent.mse.shaded.csp.sentinel.web.servlet.block.page", redirectUrl);
                    break;
                }
                case 0: {
                    int statusCode = properties.getWebRespStatusCode();
                    String scValue = SentinelConfig.getConfig("io.opentelemetry.javaagent.mse.shaded.csp.sentinel.web.servlet.block.status");
                    if (!String.valueOf(statusCode).equals(scValue)) {
                        RecordLog.info("[AdapterSettingManager] Setting block HTTP status code of default page to " + statusCode, new Object[0]);
                        SentinelConfig.setConfig("io.opentelemetry.javaagent.mse.shaded.csp.sentinel.web.servlet.block.status", String.valueOf(statusCode));
                    }
                    SentinelConfig.removeConfig("io.opentelemetry.javaagent.mse.shaded.csp.sentinel.web.servlet.block.page");
                    break;
                }
            }
            currentSetting = properties;
            currentGlobalWebBehavior = AdapterSettingManager.settingToWebFallbackBehavior(properties);
            for (Consumer consumer : OBSERVERS) {
                consumer.accept(properties);
            }
        }
    }
}

