/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.setting;

import com.alibaba.fastjson.util.ParameterizedTypeImpl;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Tuple2;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GenericTypeUtils {
    public static final String CLASS_NOT_NULL = "The class should not be null";
    public static final String PAIR_NOT_MATCH = "The pair do not match";
    public static final String ILLEGAL_COMMA_EXIST = "The parameters type should be contained in < >";
    public static final String CANNOT_MULTI_EXTEND = "The class should not multi extend";
    public static final String NOT_SUPPORT_WILD_CHAR = "do not support <?>";
    public static final String FULLY_SUCCESS = "success";
    private static List<Class> excludeList = new ArrayList<Class>(){
        {
            this.add(List.class);
            this.add(Map.class);
            this.add(Set.class);
        }
    };

    public static Type genericReturnType(String s, ClassLoader appContextClassLoader) throws ClassNotFoundException {
        LinkedList<Tuple2<Type, List<Type>>> mainStack = new LinkedList<Tuple2<Type, List<Type>>>();
        LinkedList<Character> sysStack = new LinkedList<Character>();
        char[] temp = s.toCharArray();
        boolean pairMatch = true;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < temp.length; ++i) {
            if (temp[i] == '<') {
                sysStack.push(Character.valueOf(temp[i]));
                if (!sb.toString().trim().isEmpty()) {
                    GenericTypeUtils.classBuild(sb, mainStack, appContextClassLoader);
                    if (mainStack.peek() == null || !((List)mainStack.peek().r2).isEmpty()) continue;
                    String errorMsg = "The class: [" + ((Type)mainStack.peek().r1).toString() + "] should not contain parameters";
                    throw new IllegalArgumentException(errorMsg);
                }
                throw new IllegalArgumentException(CLASS_NOT_NULL);
            }
            if (temp[i] == '>') {
                if (sysStack.peek() != null) {
                    pairMatch = GenericTypeUtils.generateCompoundType(sysStack.peek().charValue(), sb, mainStack, sysStack, appContextClassLoader);
                    continue;
                }
                throw new IllegalArgumentException(PAIR_NOT_MATCH);
            }
            if (temp[i] == ',') {
                if (sysStack.peek() == null) {
                    throw new IllegalArgumentException(ILLEGAL_COMMA_EXIST);
                }
                GenericTypeUtils.classBuild(sb, mainStack, appContextClassLoader);
                sysStack.push(Character.valueOf(temp[i]));
                continue;
            }
            sb.append(temp[i]);
        }
        if (pairMatch) {
            pairMatch = GenericTypeUtils.finalCheckProcess(sb, mainStack, sysStack, appContextClassLoader);
        }
        if (pairMatch) {
            return (Type)((Tuple2)mainStack.pop()).r1;
        }
        throw new IllegalArgumentException(PAIR_NOT_MATCH);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean finalCheckProcess(StringBuilder sb, LinkedList<Tuple2<Type, List<Type>>> mainStack, LinkedList<Character> sysStack, ClassLoader appContextClassLoader) throws ClassNotFoundException {
        if (!sb.toString().trim().isEmpty()) {
            if (!mainStack.isEmpty()) return false;
            GenericTypeUtils.classBuild(sb, mainStack, appContextClassLoader);
            Tuple2<Type, List<Type>> tuple = mainStack.peek();
            if (((List)tuple.r2).isEmpty()) return sysStack.isEmpty();
            String errorMsg = "The class: [" + ((Type)tuple.r1).toString() + "] should contains genericType: " + ((List)tuple.r2).toString() + " , but actual size is : 0";
            throw new IllegalArgumentException(errorMsg);
        }
        if (!sb.toString().trim().isEmpty() || !mainStack.isEmpty()) return sysStack.isEmpty();
        throw new IllegalArgumentException(CLASS_NOT_NULL);
    }

    public static boolean generateCompoundType(char left, StringBuilder sb, LinkedList<Tuple2<Type, List<Type>>> mainStack, LinkedList<Character> sysStack, ClassLoader appContextClassLoader) throws ClassNotFoundException {
        if (left == ',') {
            GenericTypeUtils.classBuild(sb, mainStack, appContextClassLoader);
            GenericTypeUtils.getAllTypes(true, mainStack, sysStack);
        } else if (sysStack.pop().charValue() == '<') {
            GenericTypeUtils.classBuild(sb, mainStack, appContextClassLoader);
            GenericTypeUtils.getAllTypes(false, mainStack, sysStack);
        } else {
            return false;
        }
        return true;
    }

    public static void getAllTypes(Boolean multi, LinkedList<Tuple2<Type, List<Type>>> mainStack, LinkedList<Character> sysStack) {
        ArrayList<Type> mainList = new ArrayList<Type>();
        GenericTypeUtils.getType(mainList, mainStack);
        if (multi.booleanValue()) {
            while (sysStack.pop().charValue() != '<') {
                GenericTypeUtils.getType(mainList, mainStack);
            }
            Collections.reverse(mainList);
        }
        Tuple2<Type, List<Type>> tuple = mainStack.pop();
        if (((List)tuple.r2).size() != mainList.size()) {
            String errorMsg = "The class: [" + ((Type)tuple.r1).toString() + "] should contains genericType: " + ((List)tuple.r2).toString() + " , but actual size is :" + mainList.size();
            throw new IllegalArgumentException(errorMsg);
        }
        mainStack.push(new Tuple2(new ParameterizedTypeImpl(mainList.toArray(new Type[mainList.size()]), null, (Type)tuple.r1), new ArrayList()));
    }

    public static void getType(List<Type> mainList, LinkedList<Tuple2<Type, List<Type>>> mainStack) {
        Tuple2<Type, List<Type>> tuple = mainStack.pop();
        if (!((List)tuple.r2).isEmpty()) {
            String errorMsg = "The class: [" + ((Type)tuple.r1).toString() + "] should contains genericType: " + ((List)tuple.r2).toString() + " , but actual size is :" + mainList.size();
            throw new IllegalArgumentException(errorMsg);
        }
        mainList.add((Type)tuple.r1);
    }

    public static void classBuild(StringBuilder sb, LinkedList<Tuple2<Type, List<Type>>> mainStack, ClassLoader appContextClassLoader) throws ClassNotFoundException {
        String s = sb.toString();
        Class<?> clazz = GenericTypeUtils.extendCheck(s, appContextClassLoader);
        if (!s.trim().isEmpty()) {
            String errorMsg;
            if (clazz == null) {
                String string = s.trim();
                if (string.equals("?")) {
                    throw new IllegalArgumentException(NOT_SUPPORT_WILD_CHAR);
                }
                clazz = appContextClassLoader != null ? Class.forName(string, true, appContextClassLoader) : Class.forName(string);
            }
            if (clazz.isInterface() && !excludeList.contains(clazz)) {
                errorMsg = "The class: [" + clazz.getName() + "] should not be interface ";
                throw new IllegalArgumentException(errorMsg);
            }
            if (Modifier.isAbstract(clazz.getModifiers()) && !excludeList.contains(clazz)) {
                errorMsg = "The class: [" + clazz.getName() + "] should not be Abstract ";
                throw new IllegalArgumentException(errorMsg);
            }
            mainStack.push(GenericTypeUtils.genericTypeCheck(clazz));
            sb.delete(0, sb.length());
        }
    }

    public static Class extendCheck(String s, ClassLoader appContextClassLoader) throws ClassNotFoundException {
        Class<?> parentClass;
        Class<?> childClass;
        boolean extend = true;
        if (s.contains("extends ")) {
            s = s.replace("extends ", "|");
        } else if (s.contains(" extends")) {
            s = s.replace("extends ", "|");
        } else if (s.contains(" implements")) {
            s = s.replace(" implements", "|");
        } else if (s.contains("implements ")) {
            s = s.replace("implements ", "|");
        } else if (s.contains("super ")) {
            s = s.replace("super ", "|");
            extend = false;
        } else if (s.contains(" super")) {
            s = s.replace(" super", "|");
            extend = false;
        } else {
            return null;
        }
        String[] strings = s.split("\\|");
        if (strings.length > 2) {
            throw new IllegalArgumentException(CANNOT_MULTI_EXTEND);
        }
        if (appContextClassLoader != null) {
            childClass = Class.forName(strings[0].trim(), true, appContextClassLoader);
            parentClass = Class.forName(strings[1].trim(), true, appContextClassLoader);
        } else {
            childClass = Class.forName(strings[0].trim());
            parentClass = Class.forName(strings[1].trim());
        }
        if (extend) {
            if (!parentClass.isAssignableFrom(childClass)) {
                String errorMsg = "The class [" + childClass.getName() + "] doesn't extend [" + parentClass.getName() + "]";
                throw new IllegalArgumentException(errorMsg);
            }
            return childClass;
        }
        if (!childClass.isAssignableFrom(parentClass)) {
            String errorMsg = "The class: [" + childClass.getName() + "] doesn't super [" + parentClass.getName() + "]";
            throw new IllegalArgumentException(errorMsg);
        }
        return childClass;
    }

    public static Tuple2<Type, List<Type>> genericTypeCheck(Class clazz) {
        ArrayList typesList = new ArrayList();
        if (clazz.getTypeParameters().length > 0) {
            for (TypeVariable typeVariable : clazz.getTypeParameters()) {
                if (!(typeVariable instanceof TypeVariable)) continue;
                typesList.add(typeVariable);
            }
        }
        return new Tuple2<Type, List<Type>>(clazz, typesList);
    }

    public static boolean check(char left, char right) {
        if (left == '<') {
            return right == '>';
        }
        return false;
    }
}

