/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.retry;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.AbstractRule;
import java.util.Set;

public class RetryRule
extends AbstractRule {
    public static final double DEFAULT_BACKOFF_EXPONENTIAL_MULTIPLIER = 1.5;
    public static final int DEFAULT_EXPONENTIAL_MAX_WAIT_DURATION_MS = 30000;
    private RetryIntervalStrategy retryIntervalStrategy = RetryIntervalStrategy.FIXED_INTERVAL;
    private int retryBaseIntervalMs;
    private int maxRetryTimes;
    private RetryPredicateStrategy retryPredicateStrategy = RetryPredicateStrategy.WHITELIST_EXCEPTIONS;
    private Set<String> exceptionPredicates;
    private double errorRatioUpperBound = 0.8;

    public RetryRule() {
    }

    public RetryRule(String resource) {
        this.setResource(resource);
    }

    public RetryIntervalStrategy getRetryIntervalStrategy() {
        return this.retryIntervalStrategy;
    }

    public RetryRule setRetryIntervalStrategy(RetryIntervalStrategy retryIntervalStrategy) {
        this.retryIntervalStrategy = retryIntervalStrategy;
        return this;
    }

    public int getRetryBaseIntervalMs() {
        return this.retryBaseIntervalMs;
    }

    public RetryRule setRetryBaseIntervalMs(int retryBaseIntervalMs) {
        this.retryBaseIntervalMs = retryBaseIntervalMs;
        return this;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public RetryRule setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
        return this;
    }

    public RetryPredicateStrategy getRetryPredicateStrategy() {
        return this.retryPredicateStrategy;
    }

    public RetryRule setRetryPredicateStrategy(RetryPredicateStrategy retryPredicateStrategy) {
        this.retryPredicateStrategy = retryPredicateStrategy;
        return this;
    }

    public Set<String> getExceptionPredicates() {
        return this.exceptionPredicates;
    }

    public RetryRule setExceptionPredicates(Set<String> exceptionPredicates) {
        this.exceptionPredicates = exceptionPredicates;
        return this;
    }

    public double getErrorRatioUpperBound() {
        return this.errorRatioUpperBound;
    }

    public RetryRule setErrorRatioUpperBound(double errorRatioUpperBound) {
        this.errorRatioUpperBound = errorRatioUpperBound;
        return this;
    }

    public String toString() {
        return "RetryRule{retryStrategy=" + (Object)((Object)this.retryIntervalStrategy) + ", retryBaseIntervalMs=" + this.retryBaseIntervalMs + ", maxRetryTimes=" + this.maxRetryTimes + ", retryPredicateStrategy=" + (Object)((Object)this.retryPredicateStrategy) + ", exceptionPredicates=" + this.exceptionPredicates + ", errorRatioUpperBound=" + this.errorRatioUpperBound + '}';
    }

    public static enum RetryIntervalStrategy {
        FIXED_INTERVAL(0),
        EXPONENTIAL_INTERVAL(1);

        public final int value;

        private RetryIntervalStrategy(int value) {
            this.value = value;
        }

        public static RetryIntervalStrategy of(int s) {
            if (s == RetryIntervalStrategy.FIXED_INTERVAL.value) {
                return FIXED_INTERVAL;
            }
            if (s == RetryIntervalStrategy.EXPONENTIAL_INTERVAL.value) {
                return EXPONENTIAL_INTERVAL;
            }
            return null;
        }
    }

    public static enum RetryPredicateStrategy {
        WHITELIST_EXCEPTIONS(0),
        BLACKLIST_EXCEPTIONS(1);

        public final int value;

        private RetryPredicateStrategy(int value) {
            this.value = value;
        }

        public static RetryPredicateStrategy of(int s) {
            if (s == RetryPredicateStrategy.WHITELIST_EXCEPTIONS.value) {
                return WHITELIST_EXCEPTIONS;
            }
            if (s == RetryPredicateStrategy.BLACKLIST_EXCEPTIONS.value) {
                return BLACKLIST_EXCEPTIONS;
            }
            return null;
        }
    }
}

