/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.retry;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.EagleEye;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.StatLogger;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.StatLoggerBuilder;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.LogBase;

public final class RetryLogUtil {
    private static final String RETRY_SUCCESS_STR = "retry_success";
    private static final String RETRY_FAIL_STR = "retry_fail";
    private static final String RETRY_WAIT_INTERRUPTED_STR = "retry_wait_interrupted";
    private static final String RETRY_END_ERROR_RATIO_REACHED_STR = "retry_end_error_ratio_reached";
    public static final String FILE_NAME = "sentinel-retry.log";
    private static StatLogger statLogger;

    public static void logSuccess(String resource) {
        statLogger.stat(resource, RETRY_SUCCESS_STR).count(1L);
    }

    public static void logFailure(String resource, String exceptionName) {
        statLogger.stat(resource, RETRY_FAIL_STR, exceptionName).count(1L);
    }

    public static void logWaitInterrupted(String resource) {
        statLogger.stat(resource, RETRY_WAIT_INTERRUPTED_STR).count(1L);
    }

    public static void logEndDueToErrorRatioReached(String resource, double errRatio) {
        statLogger.stat(resource, RETRY_END_ERROR_RATIO_REACHED_STR, String.format("%.3f", errRatio)).count(1L);
    }

    private RetryLogUtil() {
    }

    static {
        String path = LogBase.getLogBaseDir() + FILE_NAME;
        statLogger = ((StatLoggerBuilder)((StatLoggerBuilder)((StatLoggerBuilder)((StatLoggerBuilder)EagleEye.statLoggerBuilder("sentinel-retry-rule-logger").intervalSeconds(1).entryDelimiter('|')).keyDelimiter(',').valueDelimiter(',').maxEntryCount(6000).configLogFilePath(path)).maxFileSizeMB(20L)).maxBackupIndex(3)).buildSingleton();
    }
}

