/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.PropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DynamicSentinelProperty<T>
implements SentinelProperty<T> {
    protected Set<PropertyListener<T>> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String name;
    private volatile T value = null;

    public DynamicSentinelProperty() {
        this(null);
    }

    public DynamicSentinelProperty(T value) {
        this(null, value);
    }

    public DynamicSentinelProperty(String name, T value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public void addListener(PropertyListener<T> listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
        listener.configLoad(this.value);
    }

    @Override
    public void removeListener(PropertyListener<T> listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public boolean updateValue(T newValue) {
        if (this.isEqual(this.value, newValue)) {
            return false;
        }
        RecordLog.info("[DynamicSentinelProperty] Config will be updated to: " + newValue, new Object[0]);
        this.value = newValue;
        for (PropertyListener<T> listener : this.listeners) {
            listener.configUpdate(newValue);
        }
        return true;
    }

    private boolean isEqual(T oldValue, T newValue) {
        if (oldValue == null && newValue == null) {
            return true;
        }
        if (oldValue == null) {
            return false;
        }
        return oldValue.equals(newValue);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "{\"type\":\"" + DynamicSentinelProperty.class.getName() + "\",\"name\":\"" + this.name + '\"' + '}';
    }

    public void close() {
        this.listeners.clear();
    }
}

