/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.LogBase;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.ResourceLevelMetric;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.PidUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Function;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class MetricsReader {
    private static final int MAX_LINES_RETURN = 100000;
    private final Charset charset;
    public static final String METRIC_BASE_DIR = LogBase.getLogBaseDir();
    private final int pid = PidUtil.getPid();

    public MetricsReader(Charset charset) {
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends ResourceLevelMetric> boolean readMetricsInOneFileByEndTime(List<T> list, Function<String, T> converter, String fileName, long offset, long beginTimeMs, long endTimeMs, String identity) throws Exception {
        FileInputStream in = null;
        long beginSecond = beginTimeMs / 1000L;
        long endSecond = endTimeMs / 1000L;
        try {
            String line;
            in = new FileInputStream(fileName);
            in.getChannel().position(offset);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, this.charset));
            while ((line = reader.readLine()) != null) {
                ResourceLevelMetric node = (ResourceLevelMetric)converter.apply(line);
                long currentSecond = node.getTimestamp() / 1000L;
                if (currentSecond < beginSecond) {
                    boolean bl = false;
                    return bl;
                }
                if (currentSecond <= endSecond) {
                    if (identity == null) {
                        list.add(node);
                    } else if (node.getResource().equals(identity)) {
                        list.add(node);
                    }
                } else {
                    boolean bl = false;
                    return bl;
                }
                if (list.size() < 100000) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readMetricsInOneFile(List<MetricNode> list, String fileName, long offset, int recommendLines) throws Exception {
        long lastSecond = -1L;
        if (list.size() > 0) {
            lastSecond = list.get(list.size() - 1).getTimestamp() / 1000L;
        }
        try (FileInputStream in = null;){
            String line;
            in = new FileInputStream(fileName);
            in.getChannel().position(offset);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, this.charset));
            while ((line = reader.readLine()) != null) {
                MetricNode node = MetricNode.fromFatString(line);
                long currentSecond = node.getTimestamp() / 1000L;
                if (list.size() < recommendLines) {
                    list.add(node);
                } else {
                    if (currentSecond != lastSecond) break;
                    list.add(node);
                }
                lastSecond = currentSecond;
            }
        }
    }

    <T extends ResourceLevelMetric> List<T> readMetricsByEndTime(List<String> fileNames, Function<String, T> converter, int pos, long offset, long beginTimeMs, long endTimeMs, String identity) throws Exception {
        ArrayList list = new ArrayList(1024);
        if (this.readMetricsInOneFileByEndTime(list, converter, fileNames.get(pos++), offset, beginTimeMs, endTimeMs, identity)) {
            while (pos < fileNames.size() && this.readMetricsInOneFileByEndTime(list, converter, fileNames.get(pos++), 0L, beginTimeMs, endTimeMs, identity)) {
            }
        }
        return list;
    }

    List<MetricNode> readMetrics(List<String> fileNames, int pos, long offset, int recommendLines) throws Exception {
        ArrayList<MetricNode> list = new ArrayList<MetricNode>(recommendLines);
        this.readMetricsInOneFile(list, fileNames.get(pos++), offset, recommendLines);
        while (list.size() < recommendLines && pos < fileNames.size()) {
            this.readMetricsInOneFile(list, fileNames.get(pos++), 0L, recommendLines);
        }
        return list;
    }

    public List<String> commonRead(String fileName, long offset, int recommendLines) throws Exception {
        String realFileName;
        File file;
        ArrayList<String> list = new ArrayList<String>(recommendLines);
        String appName = SentinelConfig.getAppName();
        if (appName == null) {
            appName = "";
        }
        if (!(file = new File(realFileName = METRIC_BASE_DIR + MetricsReader.formMetricFileName(appName, this.pid, fileName))).exists()) {
            return list;
        }
        this.readInOneFile(list, realFileName, offset, recommendLines);
        return list;
    }

    public static String formMetricFileName(String appName, int pid, String metricFile) {
        if (appName == null) {
            appName = "";
        }
        String dot = ".";
        String separator = "-";
        if (appName.contains(".")) {
            appName = appName.replace(".", "-");
        }
        String name = appName + "-" + metricFile;
        if (LogBase.isLogNameUsePid()) {
            name = name + ".pid" + pid;
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readInOneFile(List<String> list, String fileName, long offset, int recommendLines) throws Exception {
        try (FileInputStream in = null;){
            String line;
            in = new FileInputStream(fileName);
            in.getChannel().position(offset);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in, this.charset));
            while ((line = reader.readLine()) != null && list.size() < recommendLines) {
                list.add(line);
            }
        }
    }

    public void commonClean(String fileName) {
        String appName = SentinelConfig.getAppName();
        if (appName == null) {
            appName = "";
        }
        String baseFileName = METRIC_BASE_DIR + MetricsReader.formMetricFileName(appName, this.pid, fileName);
        try {
            File file = new File(baseFileName);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write("");
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean commonRemove(String fileName) {
        String appName = SentinelConfig.getAppName();
        if (appName == null) {
            appName = "";
        }
        String baseFileName = METRIC_BASE_DIR + MetricsReader.formMetricFileName(appName, this.pid, fileName);
        try {
            File file = new File(baseFileName);
            if (!file.exists()) {
                return false;
            }
            return file.delete();
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

