/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.ResourceLevelMetric;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricWriter;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricsReader;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.function.Function;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.util.List;

public class MetricSearcher {
    private static final Charset defaultCharset = Charset.forName(SentinelConfig.charset());
    private final MetricsReader metricsReader;
    private String baseDir;
    private final String baseFileName;
    private Position lastPosition = new Position();

    public MetricSearcher(String baseDir, String baseFileName) {
        this(baseDir, baseFileName, defaultCharset);
    }

    public MetricSearcher(String baseDir, String baseFileName, Charset charset) {
        if (baseDir == null) {
            throw new IllegalArgumentException("baseDir can't be null");
        }
        if (baseFileName == null) {
            throw new IllegalArgumentException("baseFileName can't be null");
        }
        if (charset == null) {
            throw new IllegalArgumentException("charset can't be null");
        }
        this.baseDir = baseDir;
        if (!baseDir.endsWith(File.separator)) {
            this.baseDir = this.baseDir + File.separator;
        }
        this.baseFileName = baseFileName;
        this.metricsReader = new MetricsReader(charset);
    }

    public synchronized List<MetricNode> find(long beginTimeMs, int recommendLines) throws Exception {
        List<String> fileNames = MetricWriter.listMetricFiles(this.baseDir, this.baseFileName);
        int i = 0;
        long offsetInIndex = 0L;
        if (this.validPosition(beginTimeMs)) {
            i = fileNames.indexOf(this.lastPosition.metricFileName);
            if (i == -1) {
                i = 0;
            } else {
                offsetInIndex = this.lastPosition.offsetInIndex;
            }
        }
        while (i < fileNames.size()) {
            String fileName = fileNames.get(i);
            long offset = this.findOffset(beginTimeMs, fileName, MetricWriter.formIndexFileName(fileName), offsetInIndex);
            offsetInIndex = 0L;
            if (offset != -1L) {
                return this.metricsReader.readMetrics(fileNames, i, offset, recommendLines);
            }
            ++i;
        }
        return null;
    }

    public synchronized <T extends ResourceLevelMetric> List<T> findByTimeAndResource(long beginTimeMs, long endTimeMs, String identity, Function<String, T> converter) throws Exception {
        List<String> fileNames = MetricWriter.listMetricFiles(this.baseDir, this.baseFileName);
        int i = 0;
        long offsetInIndex = 0L;
        if (this.validPosition(beginTimeMs)) {
            i = fileNames.indexOf(this.lastPosition.metricFileName);
            if (i == -1) {
                i = 0;
            } else {
                offsetInIndex = this.lastPosition.offsetInIndex;
            }
        }
        while (i < fileNames.size()) {
            String fileName = fileNames.get(i);
            long offset = this.findOffset(beginTimeMs, fileName, MetricWriter.formIndexFileName(fileName), offsetInIndex);
            offsetInIndex = 0L;
            if (offset != -1L) {
                return this.metricsReader.readMetricsByEndTime(fileNames, converter, i, offset, beginTimeMs, endTimeMs, identity);
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validPosition(long beginTimeMs) {
        if (beginTimeMs / 1000L < this.lastPosition.second) {
            return false;
        }
        if (this.lastPosition.indexFileName == null) {
            return false;
        }
        if (!new File(this.lastPosition.indexFileName).exists()) {
            return false;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.lastPosition.indexFileName);
            in.getChannel().position(this.lastPosition.offsetInIndex);
            DataInputStream indexIn = new DataInputStream(in);
            boolean bl = indexIn.readLong() == this.lastPosition.second;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long findOffset(long beginTime, String metricFileName, String idxFileName, long offsetInIndex) throws Exception {
        this.lastPosition.metricFileName = null;
        this.lastPosition.indexFileName = null;
        if (!new File(idxFileName).exists()) {
            return -1L;
        }
        long beginSecond = beginTime / 1000L;
        FileInputStream in = new FileInputStream(idxFileName);
        in.getChannel().position(offsetInIndex);
        try (DataInputStream indexIn = new DataInputStream(in);){
            long offset;
            long second;
            this.lastPosition.offsetInIndex = in.getChannel().position();
            while ((second = indexIn.readLong()) < beginSecond) {
                offset = indexIn.readLong();
                this.lastPosition.offsetInIndex = in.getChannel().position();
            }
            offset = indexIn.readLong();
            this.lastPosition.metricFileName = metricFileName;
            this.lastPosition.indexFileName = idxFileName;
            this.lastPosition.second = second;
            long l = offset;
            return l;
        }
    }

    private static final class Position {
        String metricFileName;
        String indexFileName;
        long offsetInIndex;
        long second;

        private Position() {
        }
    }
}

