/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.PropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SimplePropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.statistic.StatConfigManager;

public class OccupyTimeoutProperty {
    private static volatile int occupyTimeout = 500;

    public static void register2Property(SentinelProperty<Integer> property) {
        property.addListener((PropertyListener<Integer>)new SimplePropertyListener<Integer>(){

            @Override
            public void configUpdate(Integer value) {
                if (value != null) {
                    OccupyTimeoutProperty.updateTimeout(value);
                }
            }
        });
    }

    public static int getOccupyTimeout() {
        return occupyTimeout;
    }

    public static void updateTimeout(int newIntervalMs) {
        if (newIntervalMs < 0) {
            RecordLog.warn("[OccupyTimeoutProperty] Illegal timeout value will be ignored: " + occupyTimeout, new Object[0]);
            return;
        }
        int slidingWindowIntervalMs = StatConfigManager.getSlidingWindowIntervalMs();
        if (newIntervalMs > slidingWindowIntervalMs) {
            RecordLog.warn("[OccupyTimeoutProperty] Illegal timeout value will be ignored: " + occupyTimeout + ", should <= " + slidingWindowIntervalMs, new Object[0]);
            return;
        }
        if (newIntervalMs != occupyTimeout) {
            occupyTimeout = newIntervalMs;
        }
        RecordLog.info("[OccupyTimeoutProperty] occupyTimeout updated to: " + occupyTimeout, new Object[0]);
    }
}

