/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.PropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SimplePropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;

public class IntervalProperty {
    private static volatile int statIntervalMs = SentinelConfig.slidingWindowStatIntervalMs();

    public static int getStatIntervalMs() {
        return statIntervalMs;
    }

    public static void register2Property(SentinelProperty<Integer> property) {
        property.addListener((PropertyListener<Integer>)new SimplePropertyListener<Integer>(){

            @Override
            public void configUpdate(Integer value) {
                if (value != null) {
                    IntervalProperty.updateInterval(value);
                }
            }
        });
    }

    public static void updateInterval(int newInterval) {
        if (newInterval != statIntervalMs) {
            statIntervalMs = newInterval;
            ClusterBuilderSlot.resetClusterNodes();
        }
        RecordLog.info("[IntervalProperty] StatInterval has been updated to " + statIntervalMs + "ms", new Object[0]);
    }
}

