/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.log.block;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config.SentinelConfig;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.log.block.BlockRuleTriggerMetricItem;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.log.block.SentinelBlockLogUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.metric.MetricWriter;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.TimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class BlockLogAggregatorTask
implements Runnable {
    private static final ExecutorService POOL = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(60), new NamedThreadFactory("sentinel-block-log-writer-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final MetricWriter metricWriter = new MetricWriter(SentinelConfig.singleMetricFileSize(), SentinelConfig.totalMetricFileCount());
    private long lastFetchTime = -1L;

    @Override
    public void run() {
        try {
            long currentTime = TimeUtil.currentTimeMillis();
            currentTime -= currentTime % 1000L;
            if (currentTime <= this.lastFetchTime) {
                return;
            }
            final TreeMap<Long, List> printMap = new TreeMap<Long, List>();
            for (Map.Entry e : SentinelBlockLogUtil.getBlockMetricMap().entrySet()) {
                BlockRuleTriggerMetricItem item = (BlockRuleTriggerMetricItem)e.getKey();
                if (item.getTimestamp() == currentTime) continue;
                if (this.isTimestampStable(item.getTimestamp(), currentTime)) {
                    if (printMap.get(item.getTimestamp()) == null) {
                        printMap.put(item.getTimestamp(), new ArrayList());
                    }
                    List itemList = (List)printMap.get(item.getTimestamp());
                    item.setBlockCount(((AtomicInteger)e.getValue()).get());
                    itemList.add(item);
                    printMap.put(item.getTimestamp(), itemList);
                }
                SentinelBlockLogUtil.getBlockMetricMap().remove(e.getKey());
            }
            this.lastFetchTime = currentTime;
            if (!printMap.isEmpty()) {
                POOL.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (Map.Entry entry : printMap.entrySet()) {
                            try {
                                BlockLogAggregatorTask.this.metricWriter.writeBlockLog((Long)entry.getKey(), (List)entry.getValue());
                            }
                            catch (Throwable e) {
                                RecordLog.error("[BlockLogAggregatorTask] Write block log item error", e);
                            }
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            RecordLog.error("[BlockLogAggregatorTask] Unexpected exception", e);
        }
    }

    private boolean isTimestampStable(long ts, long currentSecondStart) {
        return ts >= this.lastFetchTime && ts < currentSecondStart;
    }
}

