/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.extension.callback;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.context.Context;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.extension.MetricExtension;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.extension.MetricExtensionProvider;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.node.DefaultNode;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ProcessorSlotEntryCallback;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.BlockException;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.slots.block.TrafficExceptionStatisticsManager;

public class MetricEntryCallback
implements ProcessorSlotEntryCallback<DefaultNode> {
    @Override
    public void onPass(Context context, ResourceWrapper resourceWrapper, DefaultNode param, int count, Object ... args) throws Exception {
        for (MetricExtension m : MetricExtensionProvider.getMetricExtensions()) {
            String cleanResource = MetricEntryCallback.getCleanResource(resourceWrapper.getName());
            m.onPass(cleanResource, count, args);
        }
    }

    @Override
    public void onBlocked(BlockException ex, Context context, ResourceWrapper resourceWrapper, DefaultNode param, int count, Object ... args) {
        TrafficExceptionStatisticsManager.getInstance().recordBlockExceptions(resourceWrapper.getName(), resourceWrapper.getResourceType(), ex);
        for (MetricExtension m : MetricExtensionProvider.getMetricExtensions()) {
            String cleanResource = MetricEntryCallback.getCleanResource(resourceWrapper.getName());
            m.onBlocked(cleanResource, count, context.getOrigin(), ex, args);
        }
    }

    private static String getCleanResource(String resource) {
        if (resource == null || "null".equals(resource)) {
            return resource;
        }
        int index = resource.indexOf(":");
        if (index < 0) {
            return resource;
        }
        return resource.substring(index + 1);
    }
}

