/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.extension;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.extension.MetricExtension;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.metric.extension.SystemMetricExtension;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.SpiLoader;
import java.util.ArrayList;
import java.util.List;

public class MetricExtensionProvider {
    private static List<MetricExtension> metricExtensions = new ArrayList<MetricExtension>();
    private static List<SystemMetricExtension> systemMetricExtensions = new ArrayList<SystemMetricExtension>();

    private static void resolveInstance() {
        List<MetricExtension> extensions = SpiLoader.loadInstanceListSorted(MetricExtension.class);
        if (extensions == null || extensions.isEmpty()) {
            RecordLog.info("[MetricExtensionProvider] No existing MetricExtension found", new Object[0]);
        } else {
            metricExtensions.addAll(extensions);
            RecordLog.info("[MetricExtensionProvider] MetricExtension resolved, size=" + extensions.size(), new Object[0]);
        }
        List<SystemMetricExtension> sl = SpiLoader.loadInstanceListSorted(SystemMetricExtension.class);
        if (sl == null || sl.isEmpty()) {
            RecordLog.info("[MetricExtensionProvider] No existing SystemMetricExtension found", new Object[0]);
        } else {
            systemMetricExtensions.addAll(sl);
            RecordLog.info("[MetricExtensionProvider] SystemMetricExtension resolved, size=" + sl.size(), new Object[0]);
        }
    }

    public static List<MetricExtension> getMetricExtensions() {
        return metricExtensions;
    }

    public static List<SystemMetricExtension> getSystemMetricExtensions() {
        return systemMetricExtensions;
    }

    public static void addMetricExtension(MetricExtension metricExtension) {
        metricExtensions.add(metricExtension);
    }

    static {
        MetricExtensionProvider.resolveInstance();
    }
}

