/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.machine;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.machine.MachineGroupEntity;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SimplePropertyListener;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.AssertUtil;

public class MachineGroupManager {
    private static SentinelProperty<MachineGroupEntity> currentProperty = new DynamicSentinelProperty<MachineGroupEntity>();
    private static final MachineGroupPropertyListener propertyListener = new MachineGroupPropertyListener();
    private static int machineCount = 1;
    private static final int DEFAULT_APPLICATION_ADJUST_MARGIN = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<MachineGroupEntity> property) {
        AssertUtil.notNull(property, "property cannot be null");
        MachineGroupPropertyListener machineGroupPropertyListener = propertyListener;
        synchronized (machineGroupPropertyListener) {
            RecordLog.info("[MachineGroupManager] Registering new property to machine group manager", new Object[0]);
            currentProperty.removeListener(propertyListener);
            property.addListener(propertyListener);
            currentProperty = property;
        }
    }

    public static int getMachineCount() {
        return machineCount;
    }

    private static void setMachineCount(int machineCount) {
        MachineGroupManager.machineCount = machineCount;
    }

    public static int getDefaultApplicationAdjustMargin() {
        return 2;
    }

    static {
        currentProperty.addListener(propertyListener);
    }

    private static class MachineGroupPropertyListener
    extends SimplePropertyListener<MachineGroupEntity> {
        private MachineGroupPropertyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void configUpdate(MachineGroupEntity entity) {
            MachineGroupPropertyListener machineGroupPropertyListener = this;
            synchronized (machineGroupPropertyListener) {
                if (entity == null) {
                    return;
                }
                if (!MachineGroupPropertyListener.isValidProperties(entity)) {
                    RecordLog.warn("[MachineGroupManager] Ignoring invalid setting: " + entity, new Object[0]);
                    return;
                }
                if (entity.getMachineCount() != null && !entity.getMachineCount().equals(machineCount)) {
                    MachineGroupManager.setMachineCount(entity.getMachineCount());
                    RecordLog.info("[MachineGroupManager] Machine count has been updated to: " + entity.getMachineCount(), new Object[0]);
                }
            }
        }

        public static boolean isValidProperties(MachineGroupEntity entity) {
            return entity != null && entity.getMachineCount() != null && entity.getMachineCount() >= 1;
        }
    }
}

