/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.jul;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.LogBase;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.jul.ConsoleHandler;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.jul.CspFormatter;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.jul.DateFileLogHandler;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.jul.FormattingTuple;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.jul.MessageFormatter;
import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.Level;

public class BaseJulLogger {
    protected void log(PatchLogger logger, Handler handler, Level level, String detail, Object ... params) {
        if (logger == null || detail == null) {
            return;
        }
        if (!logger.isLoggable(level)) {
            return;
        }
        BaseJulLogger.disableOtherHandlers(logger, handler);
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(detail, params);
        String message = formattingTuple.getMessage();
        if (formattingTuple.getThrowable() != null) {
            logger.log(level, message, formattingTuple.getThrowable());
        } else {
            logger.log(level, message);
        }
    }

    protected void log(PatchLogger logger, Handler handler, Level level, String detail, Throwable throwable) {
        if (logger == null || detail == null) {
            return;
        }
        if (!logger.isLoggable(level)) {
            return;
        }
        BaseJulLogger.disableOtherHandlers(logger, handler);
        logger.log(level, detail, throwable);
    }

    protected Handler makeLoggingHandler(String logName, PatchLogger heliumRecordLog) {
        CspFormatter formatter = new CspFormatter();
        String logCharSet = LogBase.getLogCharset();
        Handler handler = null;
        if ("file".equals(LogBase.getLogOutputType())) {
            try {
                handler = new DateFileLogHandler(logName, LogBase.getMaxSingleFileSize(), LogBase.getMaxFileAmountPerDay(), true);
                handler.setFormatter(formatter);
                handler.setEncoding(logCharSet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if ("console".equals(LogBase.getLogOutputType())) {
            try {
                handler = new ConsoleHandler();
                handler.setFormatter(formatter);
                handler.setEncoding(logCharSet);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (handler != null) {
            BaseJulLogger.disableOtherHandlers(heliumRecordLog, handler);
        }
        heliumRecordLog.setLevel(Level.INFO);
        return handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableOtherHandlers(PatchLogger logger, Handler handler) {
        if (logger == null) {
            return;
        }
        PatchLogger patchLogger = logger;
        synchronized (patchLogger) {
            Handler[] handlers = logger.getHandlers();
            if (handlers == null) {
                return;
            }
            if (handlers.length == 1 && handlers[0].equals(handler)) {
                return;
            }
            logger.setUseParentHandlers(false);
            for (Handler h : handlers) {
                logger.removeHandler(h);
            }
            logger.addHandler(handler);
        }
    }
}

