/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.LogConfigLoader;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.ConfigUtil;
import java.io.File;
import java.util.Properties;

public class LogBase {
    public static final String LOG_DIR = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.log.dir";
    public static final String LOG_NAME_USE_PID = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.log.use.pid";
    public static final String LOG_OUTPUT_TYPE = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.log.output.type";
    public static final String LOG_CHARSET = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.log.charset";
    public static final String LOG_MAX_SINGLE_FILE_SIZE_PROP_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.logger.maxSingleFileSize";
    public static final String LOG_MAX_TOTAL_SIZE_CAP_PROP_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.logger.maxTotalSizeCap";
    public static final String LOG_MAX_FILE_AMOUNT_PER_DAY_PROP_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.logger.maxFileAmountPerDay";
    public static final String LOG_MAX_HISTORY_PROP_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.logger.maxHistoryDays";
    public static final String LOG_OUTPUT_TYPE_FILE = "file";
    public static final String LOG_OUTPUT_TYPE_CONSOLE = "console";
    public static final String LOG_CHARSET_UTF8 = "utf-8";
    public static final int DEFAULT_MAX_SINGLE_FILE_BYTE_SIZE = 0x1400000;
    public static final long DEFAULT_MAX_TOTAL_SIZE_CAP = 0x19000000L;
    public static final int DEFAULT_MAX_HISTORY_DAYS = 7;
    public static final int DEFAULT_MAX_FILE_AMOUNT_PER_DAY = 5;
    private static final String DIR_NAME = "logs" + File.separator + "csp";
    private static final String USER_HOME = "user.home";
    private static boolean logNameUsePid;
    private static String logOutputType;
    private static String logBaseDir;
    private static String logCharSet;
    private static int maxSingleFileSize;
    private static long maxTotalSizeCap;
    private static int maxTotalFileAmount;
    private static int maxFileAmountPerDay;
    private static long maxHistoryDays;

    private static void initializeDefault() {
        logNameUsePid = false;
        logOutputType = LOG_OUTPUT_TYPE_FILE;
        String logDir = System.getProperty(USER_HOME);
        if (null == logDir || logDir.length() == 0) {
            logDir = "/tmp/";
        }
        logBaseDir = ConfigUtil.addSeparator(logDir) + DIR_NAME + File.separator;
        logCharSet = LOG_CHARSET_UTF8;
    }

    private static void loadProperties() {
        int maxFileAmountPerDayParsed;
        long maxTotalCapParsed;
        Properties properties = LogConfigLoader.getProperties();
        String string = logOutputType = properties.get(LOG_OUTPUT_TYPE) == null ? logOutputType : properties.getProperty(LOG_OUTPUT_TYPE);
        if (!LOG_OUTPUT_TYPE_FILE.equalsIgnoreCase(logOutputType) && !LOG_OUTPUT_TYPE_CONSOLE.equalsIgnoreCase(logOutputType)) {
            logOutputType = LOG_OUTPUT_TYPE_FILE;
        }
        System.out.println("INFO: Sentinel log output type is: " + logOutputType);
        logCharSet = properties.getProperty(LOG_CHARSET) == null ? logCharSet : properties.getProperty(LOG_CHARSET);
        System.out.println("INFO: Sentinel log charset is: " + logCharSet);
        logBaseDir = properties.getProperty(LOG_DIR) == null ? logBaseDir : properties.getProperty(LOG_DIR);
        logBaseDir = ConfigUtil.addSeparator(logBaseDir);
        File dir = new File(logBaseDir);
        if (!dir.exists() && !dir.mkdirs()) {
            System.err.println("ERROR: create Sentinel log base directory error: " + logBaseDir);
        }
        System.out.println("INFO: Sentinel log base directory is: " + logBaseDir);
        String usePid = properties.getProperty(LOG_NAME_USE_PID);
        logNameUsePid = "true".equalsIgnoreCase(usePid);
        long maxSingleFileSizeParsed = LogBase.parseSizeBytes(properties.getProperty(LOG_MAX_SINGLE_FILE_SIZE_PROP_KEY));
        if (maxSingleFileSizeParsed > 0L) {
            maxSingleFileSize = (int)maxSingleFileSizeParsed;
        }
        if ((maxTotalCapParsed = LogBase.parseSizeBytes(properties.getProperty(LOG_MAX_TOTAL_SIZE_CAP_PROP_KEY))) > 0L) {
            maxTotalSizeCap = maxTotalCapParsed;
        }
        maxTotalFileAmount = (int)Math.ceil(1.0 * (double)maxTotalSizeCap / (double)maxSingleFileSize);
        int maxHistoryDaysParsed = LogBase.parsePositiveIntOrDefault(properties.getProperty(LOG_MAX_HISTORY_PROP_KEY), 7);
        if (maxHistoryDaysParsed > 0) {
            maxHistoryDays = maxHistoryDaysParsed;
        }
        if ((maxFileAmountPerDayParsed = LogBase.parsePositiveIntOrDefault(properties.getProperty(LOG_MAX_FILE_AMOUNT_PER_DAY_PROP_KEY), 5)) > 0) {
            maxFileAmountPerDay = maxFileAmountPerDayParsed;
        }
        System.out.printf("INFO: Sentinel logNameWithPid=%s, maxSingleFileSize=%d, maxTotalFileAmount=%d, maxHistoryDays=%d%n", logNameUsePid, maxSingleFileSize, maxTotalFileAmount, maxHistoryDays);
    }

    private static int parsePositiveIntOrDefault(String key, int defaultValue) {
        try {
            if (key == null || key.isEmpty()) {
                return defaultValue;
            }
            int v = Integer.parseInt(key);
            if (v <= 0) {
                return defaultValue;
            }
            return v;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private static long parseSizeBytes(String sizeStr) {
        if (sizeStr == null || sizeStr.isEmpty()) {
            return 0L;
        }
        long base = 1L;
        if (sizeStr.endsWith("MB") || sizeStr.endsWith("mb")) {
            base = 0x100000L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 2);
        } else if (sizeStr.endsWith("M") || sizeStr.endsWith("m")) {
            base = 0x100000L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
        } else if (sizeStr.endsWith("G") || sizeStr.endsWith("g")) {
            base = 0x40000000L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
        } else if (sizeStr.endsWith("GB") || sizeStr.endsWith("gb")) {
            base = 0x40000000L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 2);
        } else if (sizeStr.endsWith("KB") || sizeStr.endsWith("kb")) {
            base = 1024L;
            sizeStr = sizeStr.substring(0, sizeStr.length() - 2);
        }
        try {
            return base * Long.parseLong(sizeStr);
        }
        catch (Exception ex) {
            System.err.println("Failed to parse log file size: " + sizeStr + ", using default");
            return 0L;
        }
    }

    public static boolean isLogNameUsePid() {
        return logNameUsePid;
    }

    public static String getLogBaseDir() {
        return logBaseDir;
    }

    public static String getLogOutputType() {
        return logOutputType;
    }

    public static String getLogCharset() {
        return logCharSet;
    }

    public static int getMaxSingleFileSize() {
        return maxSingleFileSize;
    }

    public static long getMaxTotalSizeCap() {
        return maxTotalSizeCap;
    }

    public static long getMaxHistoryDays() {
        return maxHistoryDays;
    }

    public static int getMaxTotalFileAmount() {
        return maxTotalFileAmount;
    }

    public static int getMaxFileAmountPerDay() {
        return maxFileAmountPerDay;
    }

    static {
        maxSingleFileSize = 0x1400000;
        maxTotalSizeCap = 0x19000000L;
        maxFileAmountPerDay = 5;
        maxHistoryDays = 7L;
        try {
            LogBase.initializeDefault();
            LogBase.loadProperties();
        }
        catch (Throwable t) {
            System.err.println("[LogBase] FATAL ERROR when initializing logging config");
            t.printStackTrace();
        }
    }
}

