/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.StatEntryFunc;
import java.util.concurrent.atomic.AtomicReference;

class StatEntryFuncMinMax
implements StatEntryFunc {
    private AtomicReference<ValueRef> max = new AtomicReference<ValueRef>(new ValueRef(Long.MIN_VALUE, null));
    private AtomicReference<ValueRef> min = new AtomicReference<ValueRef>(new ValueRef(Long.MAX_VALUE, null));

    StatEntryFuncMinMax() {
    }

    @Override
    public void appendTo(StringBuilder appender, char delimiter) {
        ValueRef lmax = this.max.get();
        ValueRef lmin = this.min.get();
        appender.append(lmax.value).append(delimiter);
        if (lmax.ref != null) {
            appender.append(lmax.ref);
        }
        appender.append(delimiter);
        appender.append(lmin.value).append(delimiter);
        if (lmin.ref != null) {
            appender.append(lmin.ref);
        }
    }

    @Override
    public Object[] getValues() {
        ValueRef lmax = this.max.get();
        ValueRef lmin = this.min.get();
        return new Object[]{lmax.value, lmax.ref, lmin.value, lmin.ref};
    }

    @Override
    public int getStatType() {
        return 4;
    }

    @Override
    public void count(long count) {
        throw new IllegalStateException("count() is unavailable if minMax() has been called");
    }

    @Override
    public void countAndSum(long count, long value) {
        throw new IllegalStateException("countAndSum() is unavailable if minMax() has been called");
    }

    @Override
    public void arrayAdd(long ... values) {
        throw new IllegalStateException("arrayAdd() is unavailable if minMax() has been called");
    }

    @Override
    public void arraySet(long ... values) {
        throw new IllegalStateException("arraySet() is unavailable if minMax() has been called");
    }

    @Override
    public void batchAdd(long ... values) {
        throw new IllegalStateException("batchAdd() is unavailable if minMax() has been called");
    }

    @Override
    public void minMax(long candidate, String ref) {
        ValueRef lmax = this.max.get();
        if (lmax.value <= candidate) {
            ValueRef cmax = new ValueRef(candidate, ref);
            while (!this.max.compareAndSet(lmax, cmax)) {
                lmax = this.max.get();
                if (lmax.value <= candidate) continue;
            }
        }
        ValueRef lmin = this.min.get();
        if (lmin.value >= candidate) {
            ValueRef cmin = new ValueRef(candidate, ref);
            while (!this.min.compareAndSet(lmin, cmin)) {
                lmin = this.min.get();
                if (lmin.value >= candidate) continue;
            }
        }
    }

    @Override
    public void strArray(String ... values) {
        throw new IllegalStateException("strArray() is unavailable if minMax() has been called");
    }

    private static final class ValueRef {
        final long value;
        final String ref;

        ValueRef(long value, String ref) {
            this.value = value;
            this.ref = ref;
        }
    }
}

