/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.StatEntryFunc;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.StatEntryFuncFactory;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.StatLogger;
import java.util.Arrays;
import java.util.List;

public final class StatEntry {
    private final StatLogger statLogger;
    private final String[] keys;
    private transient int hash;

    public StatEntry(StatLogger statLogger, String key) {
        this.statLogger = statLogger;
        this.keys = new String[]{key};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3, String key4) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3, key4};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3, String key4, String key5) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3, key4, key5};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3, String key4, String key5, String key6) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3, key4, key5, key6};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3, String key4, String key5, String key6, String key7) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3, key4, key5, key6, key7};
    }

    public StatEntry(StatLogger statLogger, String key1, String key2, String key3, String key4, String key5, String key6, String key7, String key8) {
        this.statLogger = statLogger;
        this.keys = new String[]{key1, key2, key3, key4, key5, key6, key7, key8};
    }

    public StatEntry(StatLogger statLogger, String key1, String ... moreKeys) {
        String[] keys = new String[1 + moreKeys.length];
        keys[0] = key1;
        for (int i = 0; i < moreKeys.length; ++i) {
            keys[i + 1] = moreKeys[i];
        }
        this.statLogger = statLogger;
        this.keys = keys;
    }

    public StatEntry(StatLogger statLogger, List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("keys empty or null: " + keys);
        }
        this.statLogger = statLogger;
        this.keys = keys.toArray(new String[keys.size()]);
    }

    public StatEntry(StatLogger statLogger, String[] keys) {
        if (keys == null || keys.length == 0) {
            throw new IllegalArgumentException("keys empty or null");
        }
        this.statLogger = statLogger;
        this.keys = Arrays.copyOf(keys, keys.length);
    }

    public String[] getKeys() {
        return this.keys;
    }

    void appendTo(StringBuilder appender, char delimiter) {
        int len = this.keys.length;
        if (len > 0) {
            appender.append(this.keys[0]);
            for (int i = 1; i < len; ++i) {
                appender.append(delimiter).append(this.keys[i]);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("StatKeys [");
        this.appendTo(sb, ',');
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        if (this.hash == 0) {
            int result = 1;
            this.hash = result = 31 * result + Arrays.hashCode(this.keys);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatEntry other = (StatEntry)obj;
        if (this.hash != 0 && other.hash != 0 && this.hash != other.hash) {
            return false;
        }
        return Arrays.equals(this.keys, other.keys);
    }

    StatEntryFunc getFunc(StatEntryFuncFactory factory) {
        return this.statLogger.getRollingData().getStatEntryFunc(this, factory);
    }

    public void count() {
        this.count(1L);
    }

    public void count(long count) {
        this.getFunc(StatEntryFuncFactory.COUNT_SUM).count(count);
    }

    public void countAndSum(long valueToSum) {
        this.countAndSum(1L, valueToSum);
    }

    public void countAndSum(long count, long valueToSum) {
        this.getFunc(StatEntryFuncFactory.COUNT_SUM).countAndSum(count, valueToSum);
    }

    public void minMax(long candidate) {
        this.minMax(candidate, null);
    }

    public void minMax(long candidate, String ref) {
        this.getFunc(StatEntryFuncFactory.MIN_MAX).minMax(candidate, ref);
    }
}

