/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.EagleEye;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.EagleEyeAppender;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class EagleEyeRollingFileAppender
extends EagleEyeAppender {
    private static final long LOG_FLUSH_INTERVAL = TimeUnit.SECONDS.toMillis(1L);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private final int maxBackupIndex = 3;
    private final long maxFileSize;
    private final int bufferSize = 4096;
    private final String filePath;
    private final AtomicBoolean isRolling = new AtomicBoolean(false);
    private BufferedOutputStream bos = null;
    private long nextFlushTime = 0L;
    private long lastRollOverTime = 0L;
    private long outputByteSize = 0L;
    private final boolean selfLogEnabled;
    private boolean multiProcessDetected = false;
    private static final String DELETE_FILE_SUFFIX = ".deleted";

    public EagleEyeRollingFileAppender(String filePath, long maxFileSize) {
        this(filePath, maxFileSize, true);
    }

    public EagleEyeRollingFileAppender(String filePath, long maxFileSize, boolean selfLogEnabled) {
        this.filePath = filePath;
        this.maxFileSize = maxFileSize;
        this.selfLogEnabled = selfLogEnabled;
        this.setFile();
    }

    private void setFile() {
        try {
            File logFile = new File(this.filePath);
            if (!logFile.exists()) {
                File parentFile = logFile.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    this.doSelfLog("[ERROR] Fail to mkdirs: " + parentFile.getAbsolutePath());
                    return;
                }
                try {
                    if (!logFile.createNewFile()) {
                        this.doSelfLog("[ERROR] Fail to create file, it exists: " + logFile.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    this.doSelfLog("[ERROR] Fail to create file: " + logFile.getAbsolutePath() + ", error=" + e.getMessage());
                }
            }
            if (!logFile.isFile() || !logFile.canWrite()) {
                this.doSelfLog("[ERROR] Invalid file, exists=" + logFile.exists() + ", isFile=" + logFile.isFile() + ", canWrite=" + logFile.canWrite() + ", path=" + logFile.getAbsolutePath());
                return;
            }
            FileOutputStream ostream = new FileOutputStream(logFile, true);
            this.bos = new BufferedOutputStream(ostream, 4096);
            this.lastRollOverTime = System.currentTimeMillis();
            this.outputByteSize = logFile.length();
        }
        catch (Throwable e) {
            this.doSelfLog("[ERROR] Fail to create file to write: " + this.filePath + ", error=" + e.getMessage());
        }
    }

    @Override
    public void append(String log) {
        BufferedOutputStream bos = this.bos;
        if (bos != null) {
            try {
                this.waitUntilRollFinish();
                byte[] bytes = log.getBytes(EagleEye.DEFAULT_CHARSET);
                int len = bytes.length;
                if (len > 4096 && this.multiProcessDetected) {
                    len = 4096;
                    bytes[len - 1] = 10;
                }
                bos.write(bytes, 0, len);
                this.outputByteSize += (long)len;
                if (this.outputByteSize >= this.maxFileSize) {
                    this.rollOver();
                } else if (System.currentTimeMillis() >= this.nextFlushTime) {
                    this.flush();
                }
            }
            catch (Exception e) {
                this.doSelfLog("[ERROR] fail to write log to file " + this.filePath + ", error=" + e.getMessage());
                this.close();
                this.setFile();
            }
        }
    }

    @Override
    public void flush() {
        BufferedOutputStream bos = this.bos;
        if (bos != null) {
            try {
                bos.flush();
                this.nextFlushTime = System.currentTimeMillis() + LOG_FLUSH_INTERVAL;
            }
            catch (Exception e) {
                this.doSelfLog("[WARN] Fail to flush OutputStream: " + this.filePath + ", " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollOver() {
        String lockFilePath = this.filePath + ".lock";
        File lockFile = new File(lockFilePath);
        RandomAccessFile raf = null;
        FileLock fileLock = null;
        if (!this.isRolling.compareAndSet(false, true)) {
            return;
        }
        try {
            raf = new RandomAccessFile(lockFile, "rw");
            fileLock = raf.getChannel().tryLock();
            if (fileLock != null) {
                int maxBackupIndex = this.maxBackupIndex;
                this.reload();
                if (this.outputByteSize >= this.maxFileSize) {
                    File target;
                    File file = new File(this.filePath + '.' + maxBackupIndex);
                    if (file.exists() && !file.renameTo(target = new File(this.filePath + '.' + maxBackupIndex + DELETE_FILE_SUFFIX)) && !file.delete()) {
                        this.doSelfLog("[ERROR] Fail to delete or rename file: " + file.getAbsolutePath() + " to " + target.getAbsolutePath());
                    }
                    for (int i = maxBackupIndex - 1; i >= 1; --i) {
                        file = new File(this.filePath + '.' + i);
                        if (!file.exists() || file.renameTo(target = new File(this.filePath + '.' + (i + 1))) || file.delete()) continue;
                        this.doSelfLog("[ERROR] Fail to delete or rename file: " + file.getAbsolutePath() + " to " + target.getAbsolutePath());
                    }
                    target = new File(this.filePath + "." + 1);
                    this.close();
                    file = new File(this.filePath);
                    if (file.renameTo(target)) {
                        this.doSelfLog("[INFO] File rolled to " + target.getAbsolutePath() + ", " + TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - this.lastRollOverTime) + " minutes since last roll");
                    } else {
                        this.doSelfLog("[WARN] Fail to rename file: " + file.getAbsolutePath() + " to " + target.getAbsolutePath());
                    }
                    this.setFile();
                }
            }
        }
        catch (IOException e) {
            this.doSelfLog("[ERROR] Fail rollover file: " + this.filePath + ", error=" + e.getMessage());
        }
        finally {
            this.isRolling.set(false);
            if (fileLock != null) {
                try {
                    fileLock.release();
                }
                catch (IOException e) {
                    this.doSelfLog("[ERROR] Fail to release file lock: " + lockFilePath + ", error=" + e.getMessage());
                }
            }
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    this.doSelfLog("[WARN] Fail to close file lock: " + lockFilePath + ", error=" + e.getMessage());
                }
            }
            if (fileLock != null && !lockFile.delete() && lockFile.exists()) {
                this.doSelfLog("[WARN] Fail to delete file lock: " + lockFilePath);
            }
        }
    }

    @Override
    public void close() {
        BufferedOutputStream bos = this.bos;
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                this.doSelfLog("[WARN] Fail to close OutputStream: " + e.getMessage());
            }
            this.bos = null;
        }
    }

    @Override
    public void reload() {
        boolean fileNotExists;
        this.flush();
        File logFile = new File(this.filePath);
        long fileSize = logFile.length();
        boolean bl = fileNotExists = fileSize <= 0L && !logFile.exists();
        if (this.bos == null || fileSize < this.outputByteSize || fileNotExists) {
            this.doSelfLog("[INFO] Log file rolled over by outside: " + this.filePath + ", force reload");
            this.close();
            this.setFile();
        } else if (fileSize > this.outputByteSize) {
            this.outputByteSize = fileSize;
            if (!this.multiProcessDetected) {
                this.multiProcessDetected = true;
                if (this.selfLogEnabled) {
                    this.doSelfLog("[WARN] Multi-process file write detected: " + this.filePath);
                }
            }
        }
    }

    @Override
    public void cleanup() {
        try {
            String baseFileName;
            File[] filesToDelete;
            File logFile = new File(this.filePath);
            File parentDir = logFile.getParentFile();
            if (parentDir != null && parentDir.isDirectory() && (filesToDelete = parentDir.listFiles(new FilenameFilter(){
                final /* synthetic */ String val$baseFileName;
                {
                    this.val$baseFileName = string;
                }

                @Override
                public boolean accept(File dir, String name) {
                    return name != null && name.startsWith(this.val$baseFileName) && name.endsWith(EagleEyeRollingFileAppender.DELETE_FILE_SUFFIX);
                }
            })) != null && filesToDelete.length > 0) {
                for (File f : filesToDelete) {
                    boolean success;
                    boolean bl = success = f.delete() || !f.exists();
                    if (success) {
                        this.doSelfLog("[INFO] Deleted log file: " + f.getAbsolutePath());
                        continue;
                    }
                    if (!f.exists()) continue;
                    this.doSelfLog("[ERROR] Fail to delete log file: " + f.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            this.doSelfLog("[ERROR] Fail to cleanup log file, error=" + e.getMessage());
        }
    }

    void waitUntilRollFinish() {
        while (this.isRolling.get()) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
    }

    private void doSelfLog(String log) {
        if (this.selfLogEnabled) {
            EagleEye.selfLog(log);
        } else {
            System.out.println("[EagleEye]" + log);
        }
    }

    @Override
    public String getOutputLocation() {
        return this.filePath;
    }

    public String toString() {
        return "EagleEyeRollingFileAppender [filePath=" + this.filePath + "]";
    }
}

