/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.EagleEyeAppender;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.EagleEyeCoreUtils;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.EagleEyeLogDaemon;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.EagleEyeRollingFileAppender;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.StatLogController;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.StatLogger;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.StatLoggerBuilder;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.SyncAppender;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.eagleeye.TokenBucket;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;

public final class EagleEye {
    public static final String CLASS_LOCATION = EagleEye.getEagleEyeLocation();
    static final String USER_HOME = EagleEye.locateUserHome();
    static final String BASE_LOG_DIR = EagleEye.locateBaseLogPath();
    static final String EAGLEEYE_LOG_DIR = EagleEye.locateEagleEyeLogPath();
    static final String APP_LOG_DIR = EagleEye.locateAppLogPath();
    static final Charset DEFAULT_CHARSET = EagleEye.getDefaultOutputCharset();
    static final String EAGLEEYE_SELF_LOG_FILE = EAGLEEYE_LOG_DIR + "eagleeye-self.log";
    static final long MAX_SELF_LOG_FILE_SIZE = 0xC800000L;
    static EagleEyeAppender selfAppender = EagleEye.createSelfLogger();
    private static TokenBucket exceptionBucket = new TokenBucket(10L, TimeUnit.SECONDS.toMillis(10L));

    static String getEagleEyeLocation() {
        try {
            URL resource = EagleEye.class.getProtectionDomain().getCodeSource().getLocation();
            if (resource != null) {
                return resource.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "unknown location";
    }

    static Charset getDefaultOutputCharset() {
        Charset cs;
        String charsetName = EagleEyeCoreUtils.getSystemProperty("EAGLEEYE.CHARSET");
        if (EagleEyeCoreUtils.isNotBlank(charsetName)) {
            charsetName = charsetName.trim();
            try {
                cs = Charset.forName(charsetName);
                if (cs != null) {
                    return cs;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            cs = Charset.forName("GB18030");
        }
        catch (Exception e) {
            try {
                cs = Charset.forName("GBK");
            }
            catch (Exception e2) {
                cs = Charset.forName("UTF-8");
            }
        }
        return cs;
    }

    private static String locateUserHome() {
        String userHome = EagleEyeCoreUtils.getSystemProperty("user.home");
        if (EagleEyeCoreUtils.isNotBlank(userHome)) {
            if (!userHome.endsWith(File.separator)) {
                userHome = userHome + File.separator;
            }
        } else {
            userHome = "/tmp/";
        }
        return userHome;
    }

    private static String locateBaseLogPath() {
        String tmpPath = EagleEyeCoreUtils.getSystemProperty("JM.LOG.PATH");
        if (EagleEyeCoreUtils.isNotBlank(tmpPath)) {
            if (!tmpPath.endsWith(File.separator)) {
                tmpPath = tmpPath + File.separator;
            }
        } else {
            tmpPath = USER_HOME + "logs" + File.separator;
        }
        return tmpPath;
    }

    private static String locateEagleEyeLogPath() {
        String tmpPath = EagleEyeCoreUtils.getSystemProperty("EAGLEEYE.LOG.PATH");
        if (EagleEyeCoreUtils.isNotBlank(tmpPath)) {
            if (!tmpPath.endsWith(File.separator)) {
                tmpPath = tmpPath + File.separator;
            }
        } else {
            tmpPath = BASE_LOG_DIR + "eagleeye" + File.separator;
        }
        return tmpPath;
    }

    private static String locateAppLogPath() {
        String appName = EagleEyeCoreUtils.getSystemProperty("project.name");
        if (EagleEyeCoreUtils.isNotBlank(appName)) {
            return USER_HOME + appName + File.separator + "logs" + File.separator;
        }
        return EAGLEEYE_LOG_DIR;
    }

    private static final EagleEyeAppender createSelfLogger() {
        EagleEyeRollingFileAppender selfAppender = new EagleEyeRollingFileAppender(EAGLEEYE_SELF_LOG_FILE, EagleEyeCoreUtils.getSystemPropertyForLong("EAGLEEYE.LOG.SELF.FILESIZE", 0xC800000L), false);
        return new SyncAppender(selfAppender);
    }

    private static void initEagleEye() {
        try {
            EagleEye.selfLog("[INFO] EagleEye started (" + CLASS_LOCATION + "), classloader=" + EagleEye.class.getClassLoader());
        }
        catch (Throwable e) {
            EagleEye.selfLog("[INFO] EagleEye started (" + CLASS_LOCATION + ")");
        }
        try {
            EagleEyeLogDaemon.start();
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] fail to start EagleEyeLogDaemon", e);
        }
        try {
            StatLogController.start();
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] fail to start StatLogController", e);
        }
    }

    public static void shutdown() {
        EagleEye.selfLog("[WARN] EagleEye is shutting down (" + CLASS_LOCATION + ")");
        EagleEye.flush();
        try {
            StatLogController.stop();
            EagleEye.selfLog("[INFO] StatLogController stopped");
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] fail to stop StatLogController", e);
        }
        try {
            EagleEyeLogDaemon.stop();
            EagleEye.selfLog("[INFO] EagleEyeLogDaemon stopped");
        }
        catch (Throwable e) {
            EagleEye.selfLog("[ERROR] fail to stop EagleEyeLogDaemon", e);
        }
        EagleEye.selfLog("[WARN] EagleEye shutdown successfully (" + CLASS_LOCATION + ")");
        try {
            selfAppender.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private EagleEye() {
    }

    public static StatLogger statLogger(String loggerName) {
        return EagleEye.statLoggerBuilder(loggerName).buildSingleton();
    }

    public static StatLoggerBuilder statLoggerBuilder(String loggerName) {
        return new StatLoggerBuilder(loggerName);
    }

    static void setEagelEyeSelfAppender(EagleEyeAppender appender) {
        selfAppender = appender;
    }

    public static void selfLog(String log) {
        try {
            String timestamp = EagleEyeCoreUtils.formatTime(System.currentTimeMillis());
            String line = "[" + timestamp + "] " + log + "\r\n";
            selfAppender.append(line);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void selfLog(String log, Throwable e) {
        long now = System.currentTimeMillis();
        if (exceptionBucket.accept(now)) {
            try {
                String timestamp = EagleEyeCoreUtils.formatTime(now);
                StringWriter sw = new StringWriter(4096);
                PrintWriter pw = new PrintWriter((Writer)sw, false);
                pw.append('[').append(timestamp).append("] ").append(log).append("\r\n");
                e.printStackTrace(pw);
                pw.println();
                pw.flush();
                selfAppender.append(sw.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void flush() {
        EagleEyeLogDaemon.flushAndWait();
    }

    static {
        EagleEye.initEagleEye();
    }
}

