/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.datasource;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.datasource.Converter;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.datasource.ReadableDataSource;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.property.SentinelProperty;

public abstract class AbstractDataSource<S, T>
implements ReadableDataSource<S, T> {
    protected final Converter<S, T> parser;
    protected final SentinelProperty<T> property;

    public AbstractDataSource(Converter<S, T> parser) {
        if (parser == null) {
            throw new IllegalArgumentException("parser can't be null");
        }
        this.parser = parser;
        this.property = new DynamicSentinelProperty();
    }

    public AbstractDataSource(String name, Converter<S, T> parser) {
        if (parser == null) {
            throw new IllegalArgumentException("parser can't be null");
        }
        this.parser = parser;
        this.property = new DynamicSentinelProperty<Object>(name, null);
    }

    @Override
    public T loadConfig() throws Exception {
        return this.loadConfig(this.readSource());
    }

    public T loadConfig(S conf) throws Exception {
        T value = this.parser.convert(conf);
        return value;
    }

    @Override
    public SentinelProperty<T> getProperty() {
        return this.property;
    }
}

