/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.config;

import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.log.RecordLog;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.ConfigUtil;
import io.opentelemetry.javaagent.mse.shaded.com.alibaba.csp.sentinel.util.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArraySet;

public final class SentinelConfigLoader {
    public static final String SENTINEL_CONFIG_ENV_KEY = "CSP_SENTINEL_CONFIG_FILE";
    public static final String SENTINEL_CONFIG_PROPERTY_KEY = "io.opentelemetry.javaagent.mse.shaded.csp.sentinel.config.file";
    private static final String DIR_NAME = "logs" + File.separator + "csp";
    private static final String USER_HOME = "user.home";
    private static final String DEFAULT_SENTINEL_CONFIG_FILE = "classpath:sentinel.properties";
    private static Properties properties = new Properties();

    private static void load() {
        Properties p;
        String fileName = System.getProperty(SENTINEL_CONFIG_PROPERTY_KEY);
        if (StringUtil.isBlank(fileName) && StringUtil.isBlank(fileName = System.getenv(SENTINEL_CONFIG_ENV_KEY))) {
            fileName = DEFAULT_SENTINEL_CONFIG_FILE;
        }
        if ((p = ConfigUtil.loadProperties(fileName)) != null && !p.isEmpty()) {
            RecordLog.info("[SentinelConfigLoader] Loading Sentinel config from " + fileName, new Object[0]);
            properties.putAll((Map<?, ?>)p);
        }
        for (Map.Entry<Object, Object> entry : new CopyOnWriteArraySet<Map.Entry<Object, Object>>(System.getProperties().entrySet())) {
            String configKey = entry.getKey().toString();
            String newConfigValue = entry.getValue().toString();
            String oldConfigValue = properties.getProperty(configKey);
            properties.put(configKey, newConfigValue);
            if (oldConfigValue == null) continue;
            RecordLog.info("[SentinelConfigLoader] JVM parameter overrides {}: {} -> {}", configKey, oldConfigValue, newConfigValue);
        }
    }

    public static Properties getProperties() {
        return properties;
    }

    static {
        try {
            SentinelConfigLoader.load();
        }
        catch (Throwable t) {
            RecordLog.warn("[SentinelConfigLoader] Failed to initialize configuration items", t);
        }
    }
}

